/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <getopt.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "prefs.h"
#include "interface.h"
#include "support.h"

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

void help(char *argv[])
{
	printf("\n%s [OPTIONS]\n\n", argv[0]);
	printf("Options\t\tLong option\t\tmeaning\n");
	printf(" -a\t\t --beep:\t\tbeep\n");
	printf(" -b\t\t --blink:\t\tblink in shell\n");
	printf(" -h\t\t --help:\t\tthis help text\n");
	printf(" -v\t\t --version:\t\tversion informations\n");
	printf(" -l\t\t --loginshell:\t\tstart gtkterm2 with a login shell\n");
	printf(" -x xxx\t\t --win-pos-x xxx:\tSet window position to xxx pixel from upper side\n");
	printf(" -y xxx\t\t --win-pos-y xxx:\tSet window position to xxx pixel from left side\n");
	printf(" -X xxx\t\t --win-width xxx:\tSet window width to xxx chars\n");
	printf(" -Y xxx\t\t --win-height xxx:\tSet window height to xxx chars\n");
	printf(" -t\t\t --transparent:\t\tBackground is transparent\n");
	printf(" -o\t\t --opacity:\t\tSet opacity by Percent (0 - 100)\n");
	printf(" -s\t\t --stealth:\t\tGTKTerm is in stealth modus :-)\n\n");
	printf("Report bugs to <ofeige@gmx.de> or http://www.sourceforge.net/projects/gtkterm/.\n\n");
	exit(0);
}

int
main (int argc, char *argv[])
{
	GtkWidget *window;
	GtkWidget *window_about;
	gtkTermPref* pref;
	int c;
	static struct option long_options[] =
	{
		{"help", 0, 0, 'h'},
		{"version", 0, 0, 'v'},
		{"loginshell", 0, 0, 'l'},
		{"blink", 0, 0, 'b'},
		{"beep", 0, 0, 'a'},
		{"win-pos-x", 1, 0, 'x'},
		{"win-pos-y", 1, 0, 'y'},
		{"win-width", 1, 0, 'X'},
		{"win-height", 1, 0, 'Y'},
		{"transparent", 0, 0, 't'},
		{"opacity", 1, 0, 'o'},
		{"stealth", 0, 0, 's'},
		{0, 0, 0, 0}
	};


#ifdef ENABLE_NLS
	bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
#endif

	gtk_set_locale ();
	gtk_init (&argc, &argv);
	
	pref = gtkTermPref_get();

	add_pixmap_directory (PACKAGE_DATA_DIR "/" PACKAGE "/pixmaps");
	add_pixmap_directory (PACKAGE_DATA_DIR "/pixmaps");	
	add_pixmap_directory (PACKAGE_SOURCE_DIR "/pixmaps");

	while((c=getopt_long(argc, argv, "hvlx:y:X:Y:o:ts", long_options, NULL)) != EOF)
	{
		switch (c)
		{
			case 'a':
				pref->beep = TRUE;
			break;
			case 'b':
				pref->blink = TRUE;
			break;
			case 'l':
				pref->login_shell = TRUE;
			break;
			case 't':
				pref->transparent = TRUE;
			break;
			case 'x':
				pref->winPosX = atoi(optarg);
			break;
			case 'y':
				pref->winPosY = atoi(optarg);
			break;
			case 'X':
				pref->termX = atoi(optarg);
			break;
			case 'Y':
				pref->termY = atoi(optarg);
			break;
			case 's':
				pref->stealth = TRUE;
			break;
			case 'o':
				if(atoi(optarg) < 0 || atoi(optarg) >100)
				{
					printf("ERROR: -o only allowed values from 0 to 100\n\n");
					help(argv);
				}
				else
				{
					pref->opacity = (float) atoi(optarg)/100;
				}
			break;
			case 'v':
				printf("gtkterm2 version: %s\n", VERSION);
				exit(0);
			break;
			case 'h':
				help(argv);
			break;
		}
	}

	
  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
  window = create_window (pref);
  window_about = create_window_about();

  GLADE_HOOKUP_OBJECT (window, window_about, "window_about");

  gtk_widget_show (window);

  gtk_main ();
  return 0;
}
