/******************************************************************************
//             INTEL CORPORATION PROPRIETARY INFORMATION
//  This software is supplied under the terms of a license agreement or
//  nondisclosure agreement with Intel Corporation and may not be copied
//  or disclosed except in accordance with the terms of that agreement.
//        Copyright (c) 2001 Intel Corporation. All Rights Reserved.
//
//  VSS: 
//		$Workfile: FilterCoefs.h $
//		$Revision: 1 $
//		$Date: 05-02-28 16:03 $
//
//  Description:
//		Sample lowpass and highpass FIR and IIR biquad filters 
//
******************************************************************************/

/*
FIR lowpass filter
Kasier window design method 
Fstop = 1000
Fpass = 500
Astop = 45 dB 
*/
Ipp16s lpf[]=
{
17,
19,
15,
2,
-20,
-47,
-75,
-95,
-98,
-78,
-30,
43,
130,
217,
280,
299,
255,
140,
-41,
-265,
-497,
-688,
-784,
-735,
-505,
-80,
527,
1275,
2097,
2909,
3620,
4148,
4430,
4430,
4148,
3620,
2909,
2097,
1275,
527,
-80,
-505,
-735,
-784,
-688,
-497,
-265,
-41,
140,
255,
299,
280,
217,
130,
43,
-30,
-78,
-98,
-95,
-75,
-47,
-20,
2,
15,
19,
17
};

/* 
FIR highpass filter
Kasier window design method 
Fstop = 800
Fpass = 500
Astop = 100 dB
*/ 
Ipp16s hpf[]=
{
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
-1,
-1,
-1,
0,
0,
0,
1,
1,
2,
2,
2,
1,
1,
0,
-2,
-3,
-4,
-5,
-5,
-4,
-3,
0,
2,
5,
8,
10,
10,
10,
7,
3,
-2,
-8,
-13,
-18,
-20,
-20,
-17,
-10,
-2,
9,
20,
29,
35,
37,
34,
25,
11,
-7,
-26,
-43,
-56,
-63,
-62,
-50,
-30,
-3,
27,
58,
84,
100,
104,
93,
66,
28,
-20,
-70,
-115,
-149,
-165,
-158,
-128,
-75,
-6,
72,
149,
213,
252,
260,
230,
164,
65,
-55,
-181,
-297,
-384,
-425,
-410,
-332,
-194,
-8,
208,
428,
620,
753,
798,
731,
538,
215,
-226,
-764,
-1365,
-1987,
-2583,
-3107,
-3515,
-3775,
28904,
-3775,
-3515,
-3107,
-2583,
-1987,
-1365,
-764,
-226,
215,
538,
731,
798,
753,
620,
428,
208,
-8,
-194,
-332,
-410,
-425,
-384,
-297,
-181,
-55,
65,
164,
230,
260,
252,
213,
149,
72,
-6,
-75,
-128,
-158,
-165,
-149,
-115,
-70,
-20,
28,
66,
93,
104,
100,
84,
58,
27,
-3,
-30,
-50,
-62,
-63,
-56,
-43,
-26,
-7,
11,
25,
34,
37,
35,
29,
20,
9,
-2,
-10,
-17,
-20,
-20,
-18,
-13,
-8,
-2,
3,
7,
10,
10,
10,
8,
5,
2,
0,
-3,
-4,
-5,
-5,
-4,
-3,
-2,
0,
1,
1,
2,
2,
2,
1,
1,
0,
0,
0,
-1,
-1,
-1,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0,
0
};

/* IIR biquad lowpass filter 
Butterworth design 
Fstop = 500
Fpass = 700
Astop = 50 dB
*/
Ipp16s lpf_bq[]=
{
55,
107,
52,
14,
-29399,
14655,
457,
909,
453,
14,
-26747,
11855,
460,
933,
473,
14,
-24915,
9921,
1317,
2705,
1389,
14,
-23849,
8795,
5397,
5241,
0,
15,
-23499,
0
}; 

/* IIR biquad highpass filter 
Butterworth design 
Fstop = 500
Fpass = 1000
Astop = 50 dB
*/
Ipp16s hpf_bq[]=
{
12300,
-23900,
11611,
15,
-14012,
7120,
8859,
-17445,
8594,
14,
-12478,
5443,
9247,
-18586,
9348,
14,
-11455,
4326,
12478,
-25541,
13075,
14,
-21747,
7380,
28103,
-28969,
0,
15,
-21369,
0
};

/* IIR biquad highpass noise shaping filter 
Butterworth design 
Fstop = 800
Fpass = 1400
Astop = 45 dB
*/
Ipp16s NoiseShapingFilter[]=
{
4673,
-8921,
4258,
15,
-21827,
13249,
13351,
-25923,
12603,
15,
-18466,
8686,
13880,
-27729,
13882,
14,
-16327,
5783,
13029,
-26799,
13803,
14,
-15060,
4062,
9040,
-18938,
9920,
14,
-14470,
3261
};
