/******************************************************************************
//             INTEL CORPORATION PROPRIETARY INFORMATION
//  This software is supplied under the terms of a license agreement or
//  nondisclosure agreement with Intel Corporation and may not be copied
//  or disclosed except in accordance with the terms of that agreement.
//        Copyright (c) 2001 Intel Corporation. All Rights Reserved.
//
//  VSS: 
//		$Workfile: filter.h $
//		$Revision: 1 $
//		$Date: 03-09-10 17:01 $
//
//  Description:
//		IPP filtering example
******************************************************************************/

/* Standard IPP definitions */
#include <ippdefs.h>
#include <ippSP.h>

/* Signal types */
#define		TONE				0
#define		NOISE				1

/* Filter types */
#define		FIR					0
#define		IIR					1

/* Output modes */
#define		PASS_THRU			0
#define		LPF					1
#define		HPF					2

/* Default parameters */
#define		DEFAULT_TONE_AMP	16384		/* Q15 amplitude */
#define		DEFAULT_TONE_FRQ	100			/* Q15 frequency */

/* Interface */
void GetSNR(int *snr);
void SetNoiseSigma(int sigma);
void GenerateSignal(Ipp16s *signal, Ipp16s *noise, int length);
void SelectOutputMode(int mode);
void SelectFilterType(int type);
void SetToneFrequency(Ipp16s frequency, int SampleRate);
void SetToneAmplitude(Ipp16s a);


