/*
    This file is part of libkresources.

    Copyright (c) 2002 Tobias Koenig <tokoe@kde.org>
    Copyright (c) 2002 Jan-Pascal van Best <janpascal@vanbest.org>
    Copyright (c) 2003 Cornelius Schumacher <schumacher@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#include "configwidget.h"

using namespace KRES;

#ifdef _WIN32_
#include <kmessagebox.h>
#include <qdir.h>
#include <qapplication.h>
#endif

ConfigWidget::ConfigWidget( QWidget *parent, const char *name )
  : QWidget( parent, name )
{
#ifdef _WIN32_
  QString fileName ;
  fileName  = qApp->applicationDirPath () + "/kdepim/kaddressbook/icons22/";
  KGlobal::iconLoader()->setIconPath(QDir::convertSeparators(fileName));
#endif
}

void ConfigWidget::setInEditMode( bool )
{
}

void ConfigWidget::loadSettings( Resource * )
{
}

void ConfigWidget::saveSettings( Resource * )
{
}

//US #include "configwidget.moc"
