/*  This file is part of the KDE project
    Copyright (C) 2000 Simon Hausmann <hausmann@kde.org>
    Copyright (C) 2003 Luciano Montanaro <mikelima@cirulla.net>
    Copyright (C) 2001 Dirk Mueller <mueller@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
#ifndef __kcursor_h__
#define __kcursor_h__

#include <qnamespace.h>
#include <qcursor.h>

// ### compat
#include <kglobalsettings.h>

class QWidget;

class KCursor : public Qt
{
public:

    static QCursor handCursor()
        { return QCursor( Qt::PointingHandCursor ); }

    // Needed for kdelibs 3.1 codebase, check if there is a better cursor pixmap
    static QCursor workingCursor() 
        { return Qt::arrowCursor; }

    static QCursor arrowCursor()
        { return Qt::arrowCursor; }

    static QCursor upArrowCursor()
        { return Qt::upArrowCursor; }

    static QCursor crossCursor()
        { return Qt::crossCursor; }

    static QCursor sizeAllCursor()
        { return Qt::sizeAllCursor; }

    static QCursor sizeHorCursor()
        { return Qt::sizeHorCursor; }

    static QCursor sizeVerCursor()
        { return Qt::sizeVerCursor; }

    static QCursor sizeBDiagCursor()
        { return Qt::sizeBDiagCursor; }

    static QCursor sizeFDiagCursor()
        { return Qt::sizeFDiagCursor; }

    static QCursor ibeamCursor()
        { return Qt::ibeamCursor; }

    static QCursor waitCursor()
        { return Qt::waitCursor; }

    static QCursor whatsThisCursor()
        { return Qt::whatsThisCursor; }

    static void setAutoHideCursor( QWidget *, bool ) {}
};

#endif
