/*  This file is part of the KDE project
    Copyright (C) 2000 Simon Hausmann <hausmann@kde.org>
    Copyright (C) 2003 Luciano Montanaro <mikelima@cirulla.net>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
#ifndef __kdialogbase_h__
#define __kdialogbase_h__

#include <kdialog.h>

// compatibility
#include <qpixmap.h>

class QVBoxLayout;
class QHBoxLayout;
class QPushButton;

class KDialogBase : public QDialog
{
    Q_OBJECT
public:
    /**
     *  @li @p Help -    Show Help-button.
     *  @li @p Default - Show Default-button.
     *  @li @p Ok -      Show Ok-button.
     *  @li @p Apply -   Show Apply-button.
     *  @li @p Try -     Show Try-button.
     *  @li @p Cancel -  Show Cancel-button.
     *  @li @p Close -   Show Close-button.
     *  @li @p User1 -   Show User define-button 1.
     *  @li @p User2 -   Show User define-button 2.
     *  @li @p User3 -   Show User define-button 3.
     *  @li @p No -      Show No-button.
     *  @li @p Yes -     Show Yes-button.
     *  @li @p Stretch - Used internally. Ignored when used in a constructor.
     */
    enum ButtonCode
    {
      Help    = 0x00000001,
      Default = 0x00000002,
      Ok      = 0x00000004,
      Apply   = 0x00000008,
      Try     = 0x00000010,
      Cancel  = 0x00000020,
      Close   = 0x00000040,
      User1   = 0x00000080,
      User2   = 0x00000100,
      User3   = 0x00000200,
      No      = 0x00000080,
      Yes     = 0x00000100,
      Stretch = 0x80000000
    };

    KDialogBase( const QString &caption, int buttonMask, ButtonCode defaultButton,
                 ButtonCode escapeButton, QWidget *parent, const char *name,
                 bool modal, bool separator,
                 const QString &user1 = QString::null,
                 const QString &user2 = QString::null,
                 const QString &user3 = QString::null
                 );

    virtual ~KDialogBase();

    void setMainWidget( QWidget *widget );
    QWidget *mainWidget() const { return m_mainWidget; }

    void enableButtonSeparator( bool state );
    void enableButtonCancel( bool ) {}
    
    void cancel() { slotCancel(); }

private slots:
    void slotOk();
    void slotCancel();

private:
    QVBoxLayout *m_mainLayout;
    QHBoxLayout *m_buttonLayout;
    QPushButton *m_okButton;
    QPushButton *m_cancelButton;
    QWidget *m_mainWidget;
};

#endif
