#ifndef __kio_netaccess_h__
#define __kio_netaccess_h__

#include <qfile.h>

#include <kurl.h>
#include <kfileitem.h>
#include <job.h>
#include <qobject.h>
#include <qstring.h>
#include <kio/global.h>

template<typename T, typename K> class QMap;

namespace KIO
{

    class KIO_EXPORT NetAccess : public QObject
    {
    Q_OBJECT

    public:
        static bool stat( 
		const KURL &src, KIO::UDSEntry &entry, QWidget *window = 0 )
	    // FW, ML XXX Make this compile
            // { return ::stat( QFile::encodeName( src.path() ), &entry ) != -1; }
            { return false; }

        static bool download( 
		const KURL &src, QString &target, QWidget *window = 0 );

        static void removeTempFile( const QString & );

        static QString lastErrorString();
        // FIXME
       static bool synchronousRun(Job* /* job */, QWidget* /* window */, 
		                  QByteArray* /* data */ = 0,
                                    KURL* /* finalURL */ = 0, 
				    QMap<QString,QString>* /* metaData */ = 0);
    private:
        /**
        * Private constructor
        */
        NetAccess() : m_metaData(0) {}

        /**
        * Private destructor
        */
        ~NetAccess() {}

        bool synchronousRunInternal( Job* job, QWidget* window, QByteArray* data,
                                     KURL* finalURL, QMap<QString,QString>* metaData );
        void enter_loop();

        static QString* lastErrorMsg;
        static int lastErrorCode;

    private slots:
        void slotResult( KIO::Job * job );
        void slotData( KIO::Job*, const QByteArray& );
        void slotRedirection( KIO::Job*, const KURL& );

    private:
        UDSEntry m_entry;
        QByteArray m_data;
        KURL m_url;
        QMap<QString, QString> *m_metaData;

        /**
       * Whether the download succeeded or not
       */
        bool bJobOK;
    };
}

#endif
