/*  This file is part of the KDE project
    Copyright (C) 2000-2001 Simon Hausmann <hausmann@kde.org>
    Copyright (C) 2002-2003 Luciano Montanaro <mikelima@cirulla.net>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef __kio_observer_h__
#define __kio_observer_h__

#include <qstring.h>

#include <kio/global.h>
#include <kio/authinfo.h>

namespace KIO
{

    class Observer
    {
    public:
        Observer() {}
        ~Observer() {}

        static Observer *self();

        bool openPassDlg( AuthInfo &nfo );

        static int messageBox( int progressId, int type, const QString &text, 
			const QString &caption,
                        const QString &buttonYes, const QString &buttonNo );

        static int messageBox( int progressId, int type, const QString &text,
			const QString &caption,
                               const QString &buttonYes, const QString &buttonNo,
                               const QString &dontAskAgainName );

    private:
        static Observer *s_self;
    };

}

#endif
