/*
 *  linux/drivers/char/pwm520.h
 *
 *  Copyright (C) 2002 Lineo.
 *
 *  Original code write was authored by Craig Matsuura <cmatsuura@lineo.com>
 *  Parts of this code are from Sharp.
 *  This code falls under the license of the GPL.
 *
 *  This modules is for controlling the PWM audio and backlighting.
 *  Jumps for backlighting and audio must be set correctly on the LH79520
 *  Board for this module to work properly.  See Sharp LH79520 Documentation
 *  for jumper settings.
 */
#ifndef __PWM520_H
#define __PWM520_H

typedef struct {
	volatile unsigned int tc;
	volatile unsigned int dc;
	volatile unsigned int enable;
	volatile unsigned int invert;
	volatile unsigned int sync;
	volatile unsigned int res[3];
} pwmXRegs_t;

typedef struct {
    volatile pwmXRegs_t pwm0;
    volatile pwmXRegs_t pwm1;
} pwmRegs_t;

extern pwmRegs_t *pwmregs;

#define PWM_EN_ENABLE    _BIT(0)
#define PWM_INV_INVERT   _BIT(0)
#define PWM_SYNC_SYNC    _SBF(0,1)
#define PWM_SYNC_NORMAL  _SBF(0,0)

#define BACKLIGHT_INVERTER_PWM_FREQUENCY        (200) // 200Hz

// IOCTL's
#define PWM520_IOC_MAGIC    'p'
#define PWM520_IOCBEEP       _IO(PWM520_IOC_MAGIC, 0)
#define PWM520_IOCSTARTSND   _IO(PWM520_IOC_MAGIC, 1)
#define PWM520_IOCSTOPSND    _IO(PWM520_IOC_MAGIC, 2)
#define PWM520_IOCSETFREQ    _IOW(PWM520_IOC_MAGIC, 3, int)
#define PWM520_IOCSETDCYCLE  _IOW(PWM520_IOC_MAGIC, 4, int)
#define PWM520_IOCGETFREQ    _IOR(PWM520_IOC_MAGIC, 5, int)
#define PWM520_IOCGETDCYCLE  _IOR(PWM520_IOC_MAGIC, 6, int)

#define PWM520_IOCRESET      _IO(PWM520_IOC_MAGIC, 7)
#define PWM520_IOCSTOPPWM0   _IO(PWM520_IOC_MAGIC, 8)
#define PWM520_IOCINCREASEBL _IO(PWM520_IOC_MAGIC, 9)
#define PWM520_IOCDECREASEBL _IO(PWM520_IOC_MAGIC, 10)
#define PWM520_IOCSETBL      _IOW(PWM520_IOC_MAGIC, 11, int)

#define PWM520_IOC_MAXNR 11
#endif
