/*
 * linux/include/asm-arm/arch-lh79520/gpio.h
 *
 * Copyright (C) 2002 Lineo, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * Original Author:   BarnettH
 * Date:   May 17 2001 17:47:58
 *
 * Project: ARM IP headers
 *
 * Description:
 *    This file contains the structure definitions and manifest
 *    constants for ARM IP component:
 *         General Purpose Input/Output PrimeCell PL060
 *
 *         Each GPIO Module has two GPIO (digital IO) ports which are
 *         designated PORTA and PORTB.
 *
 *         Multiple instances of a GPIO module, and thus port pairs,
 *         may be implemented in a single SOC.
 *
 *         Each port has eight bits, PORTx[7:0].
 *
 *         Each port has two 8-bit registers associated with it:
 *             GPIOPxDR - Data register (dr)
 *             GPIOPxDDR - Data Direction register (ddr)
 *
 *         The specific SOC will have its own unique name for the port.
 *         Each port pair will have its own unique base address for the
 *         port pair.
 *
 *         This include file is designed to permit the definition of 
 *         pointers in the SOC map include file to distinct 8-bit ports
 *         using the name designation is suitable for the SOC
 *         implementation.
 *
 *         Example:
 *         A map file that includes this file should specify a
 *         base address for each GPIO module, e.g.:
 *
 *         #define GPIO0_BASE (0xFFFDF000)
 *         #define GPIO1_BASE (0xFFFDE000)
 *             *
 *             *
 *             *
 *
 *         The SOC map file will use these base addresses to define
 *         pointers to GPIO port A, B, C, D, E, ... thusly:
 *
 *         #define GPIOPA ((volatile GPIOAREGS *)(GPIO0_BASE))
 *         #define GPIOPB ((volatile GPIOBREGS *)(GPIO0_BASE))
 *         #define GPIOPC ((volatile GPIOAREGS *)(GPIO1_BASE))
 *         #define GPIOPD ((volatile GPIOBREGS *)(GPIO1_BASE))
 *         #define GPIOPE ((volatile GPIOAREGS *)(GPIO2_BASE))
 *             *
 *             *
 *             *
 *
 *         Example usage of these definitions in user code for Port C:
 *
 *             unsigned int data;
 *
 *             GPIOC->ddr = 0xF;    sets bits [7:4] as outputs
 *                                  and bits [3:0] as inputs
 *             GPIOC->dr  = 0xF0;   sets bits [7:4] to "1"
 *
 *             data = GPIOC->dr;    sets data to the value of
 *                                  data register
 *
 *   Note: If it is desired to use the type qualifier "__packed"
 *          to enable packing of structures, the manifest constant
 *          "PACKED" must be defined as follows or as a
 *          predefine at compilation (ARM-specific notation):
 *
 *    #define PACKED __packed
 *
 *    If a different compiler/preprocessor is used, the appropriate
 *    notation must be substituted for "__packed".
 *
 *    Reference: ARM PrimeCell General Purpose Input/Output (PL060)
 *               Technical Reference Manual, ARM DDI 0142B.
 *
 *    Revision History:
 * 
 *    Rev 1.1   May 17 2001 17:47:58   BarnettH
 * Changed structure component types to reflect 32-bit access requirements.
 * 
 *    Rev 1.0   Mar 30 2001 16:03:30   BarnettH
 * Initial revision.
 * 
 *    COPYRIGHT (C) 2001 SHARP MICROELECTRONICS OF THE AMERICAS, INC.
 *    CAMAS, WA
 *********************************************************************/

#ifndef ARM_GPIO_PL060_H
#define ARM_GPIO_PL060_H

/* GPIO Register Structures */ 
//typedef __attribute((packed)) struct {
typedef struct {
    volatile unsigned int dr;
    volatile unsigned int reserveda1;
    volatile unsigned int ddr;
    volatile unsigned int reserveda2;
} gpioARegs_t;

//typedef __attribute((packed)) struct {
typedef struct {
    volatile unsigned int reservedb1;
    volatile unsigned int dr;
    volatile unsigned int reservedb2;
    volatile unsigned int ddr;
} gpioBRegs_t;

/*
 * The names and usage of the bit fields in these registers is
 * implementation specific, so few bit field constants are defined.
 */ 

#ifndef _BIT
#define _BIT(n) (1 << (n))
#endif

#ifndef _SBF
#define _SBF(f,v) ((v) << (f))
#endif

#define SSPFRM_GPIO_BIT _BIT(2)

#endif /* ARM_GPIO_PL060_H */ 

