/*!--------------------------------------------------------------------------
 * \file	mem_map.h
 * \brief	This file maps all cardengine CPLD ranges and registers.
 */
/*  Copyright 2002, Logic Product Development, Inc. All Rights Reserved.
 *
 * NOTICE:
 *  This file contains source code, ideas, techniques, and information
 *  (the Information) which are Proprietary and Confidential Information
 *  of Logic Product Development, Inc.  This Information may not be used
 *  by or disclosed to any third party except under written license, and
 *  shall be subject to the limitations prescribed under license.
 *
 *-------------------------------------------------------------------------*/
#ifndef LPD_CPLD_H
#define LPD_CPLD_H

#include <asm/arch/hardware.h>

#define MEMAP_BASE_CPLD_FAST		(LPD_CPLD_BASE - 0x00200000)
#define MEMAP_BASE_CPLD_SLOW		(LPD_CPLD_BASE - 0x00200000)

#define REG16(base)					(*((volatile unsigned short *)(base)))

/*
 * The fast io on the CardEngines
 */
/*#define CPLD_CE_CS_WRLAN_1			(MEMAP_BASE_CPLD_FAST + 0x00000000)*/
#define CPLD_CE_REG_WRLAN_1			(MEMAP_BASE_CPLD_FAST + 0x00200000)
#define CPLD_CE_CS_CODEC_I2S		(MEMAP_BASE_CPLD_FAST + 0x00400000)
#define CPLD_CE_REG_SPI_DATA		(MEMAP_BASE_CPLD_FAST + 0x00600000)
#define CPLD_CE_REG_SPI_CONTROL		(MEMAP_BASE_CPLD_FAST + 0x00800000)
#define CPLD_CE_REG_EEPROMSPI		(MEMAP_BASE_CPLD_FAST + 0x00a00000)
#define CPLD_CE_REG_INTMASK			(MEMAP_BASE_CPLD_FAST + 0x00c00000)
#define CPLD_CE_REG_MODE			(MEMAP_BASE_CPLD_FAST + 0x00e00000)
#define CPLD_CE_REG_FLASH			(MEMAP_BASE_CPLD_FAST + 0x01000000)
#define CPLD_CE_REG_SDRAM			(MEMAP_BASE_CPLD_FAST + 0x01200000)
#define CPLD_CE_REG_REVISION		(MEMAP_BASE_CPLD_FAST + 0x01400000)
#define CPLD_CE_REG_LED				(MEMAP_BASE_CPLD_FAST + 0x01600000)

/*
 * The slow io on the CardEngines
 */
#define CPLD_CE_CS_SUPERIO			(MEMAP_BASE_CPLD_SLOW + 0x00000000)
#define CPLD_CE_CS_COMPACTFLASH		(IDE_BASE)
#define CPLD_CE_CS_ISA				(MEMAP_BASE_CPLD_SLOW + 0x00400000)

/* this is how we get to the REG line on the CF slot.
 * REG must be high to access 'common memory'
 * we're cheating and setting both A11 and A12 high
 * because on old LCEs REG goes to A11 and new ones
 * it goes to A12.  The other line is unused, so it
 * doesn't matter if we set them both. */
#define CPLD_CE_CS_COMPACTFLASH_REG	(CPLD_CE_CS_COMPACTFLASH + 0x1800)


/*
 * The fast io on EBX boards
 */
#define CPLD_EBX_CS_WRLAN_2			(MEMAP_BASE_CPLD_FAST + 0x02000000)
#define CPLD_EBX_CS_USB				(MEMAP_BASE_CPLD_FAST + 0x02100000)
#define CPLD_EBX_REG_DIP			(MEMAP_BASE_CPLD_FAST + 0x02200000)
#define CPLD_EBX_REG_LED			(MEMAP_BASE_CPLD_FAST + 0x02300000)
#define CPLD_EBX_REG_PWRMGMT		(MEMAP_BASE_CPLD_FAST + 0x02400000)
#define CPLD_EBX_REG_INTMASK0		(MEMAP_BASE_CPLD_FAST + 0x02500000)
#define CPLD_EBX_REG_INTMASK1		(MEMAP_BASE_CPLD_FAST + 0x02600000)
#define CPLD_EBX_REG_PROCTYPE		(MEMAP_BASE_CPLD_FAST + 0x02700000)

/*
 * The slow io on EBX boards
 */
#define CPLD_EBX_CS_RTC				(MEMAP_BASE_CPLD_SLOW + 0x02000000)


/*-------------------------------------------------------------------------*/
/*!
 * Below here are fields in the CPLD registers.
 */
/*-------------------------------------------------------------------------*/

/*
 * Register fields on the CardEngine's CPLD
 */
#define CPLD_CE_WRLAN_DISABLE		0x1

#define CPLD_CE_SPI_CNTL_REG_LOADED	0x20
#define CPLD_CE_SPI_CNTL_LOAD_REG	0x10
#define CPLD_CE_SPI_CNTL_DONE		0x8
#define CPLD_CE_SPI_CNTL_RD			0x4
#define CPLD_CE_SPI_CNTL_TOUCH		0x2
#define CPLD_CE_SPI_CNTL_CODEC		0x1

#define CPLD_CE_EEPROMSPI_CS		0x8
#define CPLD_CE_EEPROMSPI_CLK		0x4
#define CPLD_CE_EEPROMSPI_TX		0x2
#define CPLD_CE_EEPROMSPI_RX		0x1

#define CPLD_CE_INTMASK_PENIRQ		0x10
#define CPLD_CE_INTMASK_MSK_TOUCH	0x8
#define CPLD_CE_INTMASK_MSK_WRLAN	0x4
#define CPLD_CE_INTMASK_INT_TOUCH	0x2		/* Active low */
#define CPLD_CE_INTMASK_INT_WRLAN	0x1		/* Active low */

#define CPLD_CE_MODE_dunno			dunnoyet

#define CPLD_CE_FLASH_STS2			0x4
#define CPLD_CE_FLASH_STS1			0x2
#define CPLD_CE_FLASH_PGM_EN		0x1

#define CPLD_CE_SDRAM_CLK_EN		0x1

#define CPLD_CE_REVISION_MASK		0xff

#define CPLD_CE_LED1_ON				0x0
#define CPLD_CE_LED1_OFF			0x1
#define CPLD_CE_LED2_ON				0x0
#define CPLD_CE_LED2_OFF			0x2

/*
 * Register fields on the EBX CPLD
 */
#define CPLD_EBX_PWRMEMT_xxx		dunnoyet
#define CPLD_EBX_INTMASK0_xxx		dunnoyet
#define CPLD_EBX_INTMASK1_xxx		dunnoyet

#define CPLD_EBX_PROCTYPE_MASK		0x07
#define CPLD_EBX_PROCTYPE_7727		0x00
#define CPLD_EBX_PROCTYPE_7750R		0x01
#define CPLD_EBX_PROCTYPE_7760		0x02
#define CPLD_EBX_PROCTYPE_79520		0x03
#define CPLD_EBX_PROCTYPE_A400		0x04
#define CPLD_EBX_PROCTYPE_A405		0x05
#define CPLD_EBX_PROCTYPE_5401		0x06
#define CPLD_EBX_PROCTYPE_OMAP5910	0x07

#define CPLD_EBX_PROCTYPE_CODEC_MASK 0x18
#define CPLD_EBX_PROCTYPE_CODECPHIL	0x00
#define CPLD_EBX_PROCTYPE_CODECTI	0x08
#define CPLD_EBX_PROCTYPE_CODECWOLF	0x10

#define CPLD_EBX_PROCTYPE_BOARD_MASK 0xe0
#define CPLD_EBX_PROCTYPE_BOARD_LCE	0x00
#define CPLD_EBX_PROCTYPE_BOARD_EBX	0x20
#define CPLD_EBX_PROCTYPE_BOARD_PCI	0x40
#define CPLD_EBX_PROCTYPE_BOARD_ext	(?0x60)

#endif /* LPD_CPLD_H */
