/* vi: set sw=4 ts=4 ai: */

/**********************************************************************
*  linux/include/linux/verbosedebug.h
*
*  Provide Verbose, Debug, and Verbose+Debug printk macros that can be
*  enabled or disabled vi the definitions of DEBUG and VERBOSE.
*
*  vprintk	-- Verbose printk
*  dprintk	-- Debug printk
*  vdprintk	-- Verbose+Debug printk
*
*  Copyright (C) 2002  Lineo, Inc.
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License (GPL) version 2
*  as published by the Free Software Foundation.
*
**********************************************************************/

#ifndef _VerboseDebug_h
#define _VerboseDebug_h

#ifndef DRVNAME
#	define DRVNAME ""
#endif

#ifdef VERBOSE
#   ifdef DEBUG
#       define vprintk(fmt,args...) {printk(DRVNAME ": " fmt, ## args);}
#       define dprintk(fmt,args...) {printk(DRVNAME ": " fmt, ## args);}
#       define vdprintk(fmt,args...) {printk(DRVNAME ": " fmt, ## args);}
#   else
#       define vprintk(fmt,args...) {printk(DRVNAME ": " fmt, ## args);}
#       define dprintk(fmt,args...) {}
#       define vdprintk(fmt,args...) {}
#   endif
#else
#   ifdef DEBUG
#       define vprintk(fmt,args...) {}
#       define dprintk(fmt,args...) {printk(DRVNAME ": " fmt, ## args);}
#       define vdprintk(fmt,args...) {}
#   else
#       define vprintk(fmt,args...) {}
#       define dprintk(fmt,args...) {}
#       define vdprintk(fmt,args...) {}
#   endif
#endif

#endif /* _VerboseDebug_h */

