/*
 * Hardware definitions for HP iPAQ Handheld Computers
 *
 * Copyright 2000-2003 Hewlett-Packard Company.
 *
 * Use consistent with the GNU GPL is permitted,
 * provided that this copyright notice is
 * preserved in its entirety in all copies and derived works.
 *
 * COMPAQ COMPUTER CORPORATION MAKES NO WARRANTIES, EXPRESSED OR IMPLIED,
 * AS TO THE USEFULNESS OR CORRECTNESS OF THIS CODE OR ITS
 * FITNESS FOR ANY PARTICULAR PURPOSE.
 *
 * Author: Jamey Hicks.
 *
 * History:
 *
 * 2003-05-14	Joshua Wise        Adapted for the HP iPAQ H1900
 * 2002-08-23   Jamey Hicks        Adapted for use with PXA250-based iPAQs
 * 2001-10-??   Andrew Christian   Added support for iPAQ H3800
 *                                 and abstracted EGPIO interface.
 *
 */
#include <linux/module.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/tty.h>
#include <linux/sched.h>
#include <linux/pm.h>
#include <linux/bootmem.h>

#include <asm/irq.h>
#include <asm/hardware.h>
#include <asm/setup.h>

#include <asm/mach/irq.h>
#include <asm/mach/arch.h>
#include <asm/mach/map.h>

#include <asm/arch/irq.h>
#include <asm/types.h>

#include <linux/serial_core.h>

#include "generic.h"

struct ipaq_model_ops ipaq_model_ops;
EXPORT_SYMBOL(ipaq_model_ops);

void ipaq_set_led (enum led_color color, int duty_time, int cycle_time)
{
	if (ipaq_model_ops.set_led)
		ipaq_model_ops.set_led (color, duty_time, cycle_time);
}
EXPORT_SYMBOL(ipaq_set_led);

void ipaq_backlight_power (int on)
{
	if (ipaq_model_ops.backlight_power)
		ipaq_model_ops.backlight_power (on);
}
EXPORT_SYMBOL(ipaq_backlight_power);

#define NR_SERIAL 3

void ipaq_serial_power_hook (int line, int state)
{
	static int power_state[NR_SERIAL];

	if (line >= NR_SERIAL)
		return;

	if (state) {
		power_state[line]++;
		if (power_state[line] == 1) {
			switch (line) {
			case 0:
				set_h3600_egpio(IPAQ_EGPIO_RS232_ON);
				break;
			case 1:
				ipaq_led_blink(BLUE_LED,1,7);
				set_h3600_egpio(IPAQ_EGPIO_BLUETOOTH_ON);
				break;
			}
		}
	} else {
		if (power_state[line] == 1) {
			switch (line) {
			case 0:
				clr_h3600_egpio(IPAQ_EGPIO_RS232_ON);
				break;
			case 1:
				ipaq_led_off(BLUE_LED);
				clr_h3600_egpio(IPAQ_EGPIO_BLUETOOTH_ON);
				break;
			}
		}
		power_state[line]--;
	}	
}




#if defined(CONFIG_PCMCIA) || defined(CONFIG_PCMCIA_MODULE)

int h3600_egpio_set_irq_type(enum ipaq_egpio_type egpio_nr, unsigned int type)
{
	struct egpio_irq_info *info = NULL;
#ifdef CONFIG_ARCH_H3900
	if (machine_is_h3900()) {
		extern struct egpio_irq_info h3900_egpio_irq_info[];
		info = h3900_egpio_irq_info;
	}
#endif
#ifdef CONFIG_ARCH_H5400
	if (machine_is_h5400()) {
		extern struct egpio_irq_info h5400_egpio_irq_info[];
		info = h5400_egpio_irq_info;
	}
#endif

	BUG_ON(info == NULL);

	while (info->irq != 0) {
		if (info->egpio_nr == egpio_nr) {
			if (0) printk("%s: egpio_nr=%d gpio=%x irq=%d\n", __FUNCTION__, egpio_nr, info->gpio_nr, info->irq);
			set_GPIO_IRQ_edge( info->gpio_nr, type);
			return 0;
		}
		info++;
	}
	printk("%s: unhandled egpio_nr=%d\n", __FUNCTION__, egpio_nr); 
	return -EINVAL;
}
EXPORT_SYMBOL(h3600_egpio_set_irq_type);

int h3600_egpio_request_irq(enum ipaq_egpio_type egpio_number,
			    void (*handler)(int, void *, struct pt_regs *),
			    unsigned long flags, const char *name, void *dev_id)
{
	int pxa_irq = h3600_egpio_irq_number(egpio_number);
	int rc = request_irq( pxa_irq, handler, flags, name, dev_id);
	printk("h3600_egpio_request_irq: egpio_nr=%d pxa_irq=%d handler=%p rc=%d\n", egpio_number, pxa_irq, handler, rc);
	return rc;
}
EXPORT_SYMBOL(h3600_egpio_request_irq);

void h3600_egpio_free_irq(enum ipaq_egpio_type egpio_number, void *dev_id)
{
	int pxa_irq = h3600_egpio_irq_number(egpio_number);
	free_irq( pxa_irq, dev_id );
}
EXPORT_SYMBOL(h3600_egpio_free_irq);

#endif
