/* 
 * 2002 (C) Copyrigt SAMSUMNG ELECTRONICS 
 *           SW.LEE <hitchcar@sec.samsung.com>
 * 
 * 	    Low-level MMC functions for the S3CXX
 *
 * Copyright 2002 Hewlett-Packard Company
 *
 * Use consistent with the GNU GPL is permitted,
 * provided that this copyright notice is
 * preserved in its entirety in all copies and derived works.
 *
 * HEWLETT-PACKARD COMPANY MAKES NO WARRANTIES, EXPRESSED OR IMPLIED,
 * AS TO THE USEFULNESS OR CORRECTNESS OF THIS CODE OR ITS
 * FITNESS FOR ANY PARTICULAR PURPOSE.
 *
 * Many thanks to Alessandro Rubini and Jonathan Corbet!
 *
 * Author:  Andrew Christian
 *          6 May 2002
 */


#include <linux/module.h>
#include <linux/version.h>

#include <linux/init.h>
#include <linux/sched.h>
#include <linux/interrupt.h>
#include <linux/proc_fs.h>
#include <linux/delay.h>

#include <asm/irq.h>       
#include <asm/unaligned.h>

#include <asm/arch/hardware.h>
#include <linux/mmc/mmc_ll.h>
#include "mmc_samsung.h"

/*---------------------------------------------------------------------------------*/
static void s3c2410_slot_init(struct s3c_mmc_lowlevel *lowlevel)
{
    /* External Interrupt for Card detect
     * connected with nCS_SD -> nCD (SO CARD SOCKET )
     * PULL-UP  
     */
    // rGPGUP = 0xF800; defalt value
    DEBUG(2,"    Before   rGPGCON 0x%08X    \n",rGPGCON);
    rGPGCON &= ~((0x3 << 20));
    rGPGCON |=  ((0x2 << 20));   /* External Interrupt #18 Enable */
    DEBUG(2,"    After     rGPGCON 0x%08X    \n",rGPGCON);
   
   /************************************
    * SDDAT  [21:14]
    * SDCMD  [13:12]
    * SDCLK  [11:10]
    ***********************************/   
    rGPEUP  = 0xf83f;     // The pull up
    rGPECON = 0xaaaaaaaa;

    /*
     *  External Interrupt level - Both edge triggered
     */
    rEXTINT2 &= ~(0x7<<8);
    rEXTINT2 |= (0x7<<8);
}

/*******
 * Prototype 
 *  static int  mmc_s3c_slot_is_empty (int slot)
 * Purpose:
  * Entry
 * Exit
 *        1  : slot is empty
 *        0  : occupied
 * Exceptions:
 *****************************************************/
static int  mmc_s3c2410_slot_is_empty (struct s3c_mmc_lowlevel *lowlevel)
{
	int retval;
	DEBUG(2,"\n");
	/* Change Port to Input mode  */
	DEBUG(2,"    INT   rGPGCON 0x%08X    \n",rGPGCON);

	rGPGCON  &= ~(0x3<<20);
	DEBUG(2,"    INPUT rGPGCON 0x%08X    \n",rGPGCON);
	DEBUG(2,"          rGPGDAT 0x%08X    \n",rGPGDAT);
	mmc_delay();		/* I amn' sure of how long time to
				   need to stable signal */
        if( rGPGDAT & (0x1<<10)){	
	        retval = 1;
	}
	else {
	        retval = 0;
	}
	rGPGCON |= (0x2<<20);	/* Change port to EINT18 Mode */
	DEBUG(2,"    INT   rGPGCON 0x%08X    \n",rGPGCON);
	return retval;
}

/*******
 * Prototype 
 *static void mmc_s3c_fix_sd_detect( unsigned long nr )
 *
 * Purpose:
 *       1. Kernel booting with SD inserted.
 *              level interrupt setting.
 *       2, After kernel booting , SD inserted
 *              Both interrupt setting
 *          
 *           When interrupt happens,
 *                 1, take the time to make the signal stable 
 *                    in some time interval, we have n trials
 *                 2. if P(n)>= 90 % , the insert /eject state will be accepted.
 *       3. To test insert or eject we can read the GPIO
 *
 * Entry
 * Exit
 * Exceptions:
 *****************************************************/
static void mmc_s3c_fix_sd_detect( unsigned long nr )
{
	MMC_DEBUG(2,"     INT rGPGCON 0x%08X    ",rGPGCON);
	
	/* Change Port to Input mode  */
	rGPGCON  &= ~(0x3<<20);
	MMC_DEBUG(2,"    INPUT rGPGCON 0x%08X    ",rGPGCON);
	MMC_DEBUG(2,"          rGPGDAT 0x%08X    ",rGPGDAT);

        if( rGPGDAT & (0x1<<10)){	/* eject */
		MMC_DEBUG(2," MMC Card eject   ");
	        g_s3c_data.insert = 0;	     
  		mmc_eject(0);
		//		g_s3c_asic_statistics.mmc_insert++;
	}
	else {
	        if ( g_s3c_data.insert ) {
			MMC_DEBUG(2,"      MMC Card already inserted  ");
		}
		else{
			MMC_DEBUG(2,"    MMC Card insert  ");
		        g_s3c_data.insert = 1;
		        mmc_insert(0);
		}
		//		g_s3c_asic_statistics.mmc_eject++;
	}
	rGPGCON |= (0x2<<20);	/* Change port to EINT18 Mode */
}

struct s3c_mmc_lowlevel s3c2410_mmc_lowlevel = {
	.name = "s3c2410_mmc";
	.sd_base = VA_SD_BASE;
	.sdi_irq = IRQ_SDI;
	.detect_irq = IRQ_EINT18;
	.slot_init = s3c2410_slot_init;
	.slot_is_empty = mmc_s3c2410_slot_is_empty;
};

static int __init s3c2410_mmc_init(void)
{
        int retval;

	retval = s3c_mmc_register_slot(&s3c2410_mmc_lowlevel);
	if ( retval < 0 )
		printk(KERN_INFO __FUNCTION__ ": unable to register slot\n");

	return retval;
}

void __exit s3c2410_mmc_cleanup(void)
{
	MMC_DEBUG(0,"");
	s3c_mmc_unregister_slot(&s3c2410_mmc_lowlevel);
}


module_init(s3c2410_mmc_init);
module_exit(s3c2410_mmc_cleanup);

MODULE_AUTHOR("Sangwook Lee<hitchcar@sec.samsung.com");
MODULE_LICENSE("GPL");
MODULE_DESCRIPTION("S3C2410 SD/MMC driver ");
