/*
 * linux/include/asm-arm/io.h
 *
 * Copyright (C) 1996 Russell King
 *
 * Modifications:
 *  16-Sep-1996	RMK	Inlined the inx/outx functions & optimised for both
 *			constant addresses and variable addresses.
 */
#ifndef __ASM_ARM_IO_H
#define __ASM_ARM_IO_H




#define __outbc(value,port)						\
({									\
		__asm__ __volatile__(					\
		"strb	%0, [%1,#0]"						\
		: : "r" (value), "r" (port));				\
})

#define __outlc(value,port)						\
({									\
		__asm__ __volatile__(					\
		"str	%0, [%1,#0]"					\
		: : "r" (value), "r" (port));				\
})

#define __inbc(port)							\
({									\
	unsigned char result;						\
		__asm__ __volatile__(					\
		"ldrb	%0, [%1,#0]"					\
		: "=r" (result) : "r" (port));				\
	result;								\
})

#define __inlc(port)							\
({									\
	unsigned int result;						\
		__asm__ __volatile__(					\
		"ldr	%0, [%1,#0]"					\
		: "=r" (result) : "r" (port));				\
	result;								\
})

#define __INS(s,i,x) \
extern void ins##s(unsigned int port, void *to, int len);

#define __OUTS(s,i,x) \
extern void outs##s(unsigned int port, const void *from, int len);

/*
 * These macros actually build the inline functions and/or the function prototypes
 */
#define __OUT(s,i,x) \
  __OUTS(s,i,x)

#define __IN(s,i,x) \
  __INS(s,i,x)

#define __IO(s,i,x) \
  __OUT(s,i,x) \
  __IN(s,i,x)

__IO(b,"b",char)
__IO(l,"",long)

#define outb(val,port)	\
  (__outbc((val),(port)))

#define outl(val,port)	\
  (__outlc((val),(port)))

#define inb(port)	\
  (__inbc((port)))

#define inl(port)	\
  (__inlc((port)))

#endif

