#!/bin/bash
#
# test-pings.sh
# ====
#
# Tests default _NET_WM_PING handling in matchbox.
#

# Must be a _NET_WM_PING capable app ( eg any GTK2 one ) 
APP=gtk-demo
if [ -z $(which $APP|grep "/$APP") ]; then
   echo "$0: test app '$APP' missing."
   exit 2 # 2 indicates mis-setup 
fi

( $APP ) &
PID=$!

echo "$0: $APP forked, waiting for it to start."
sleep 5

# background it
echo "$0: Sending SIGSTOP to $APP to simulate hang."
kill -STOP $PID

# wait a while
echo "$0: Waiting 30 seconds for WM to take action."
sleep 30

kill -0 $PID

if [ $? -eq 0 ] 
then
  echo "$0: Test Succeeded"
  exit 0
else  
  echo "$0: Test Failed - process appears to still exist"
  exit 1
fi


