#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>

Window Window_With_Name(dpy, top, name)
     Display *dpy;
     Window top;
     char *name;
{
	Window *children, dummy;
	unsigned int nchildren;
	int i;
	Window w=0;
	char *window_name;

	if (XFetchName(dpy, top, &window_name) && !strcmp(window_name, name))
	  return(top);

	if (!XQueryTree(dpy, top, &dummy, &dummy, &children, &nchildren))
	  return(0);

	for (i=0; i<nchildren; i++) {
		w = Window_With_Name(dpy, children[i], name);
		if (w)
		  break;
	}
	if (children) XFree ((char *)children);
	return(w);
}

#define MB_CMD_SHOW_EXT_MENU 6

int main(int argc, char **argv)
{
	Window window;
	Display *dpy;
	XEvent ev;

	dpy = XOpenDisplay(":0");
	if (!dpy) {
		fprintf(stderr, "Cannot open display.\n");
		exit(1);
	}
	
	window = Window_With_Name(dpy, DefaultRootWindow(dpy), "App Launcher");
	if (!window) {
		fprintf(stderr, "Cannot find a window by that name.\n");
		exit(1);
	}

	memset(&ev, 0, sizeof(ev));
	ev.xclient.type = ClientMessage;
	ev.xclient.window = window;
	ev.xclient.message_type = XInternAtom(dpy, "_MB_COMMAND", True);
	ev.xclient.format = 32;
	ev.xclient.data.l[0] = MB_CMD_SHOW_EXT_MENU;
   
	XSendEvent(dpy, window, False, NoEventMask, &ev);
	XSync(dpy, False);

	XCloseDisplay(dpy);
	
	return 0;
}
