#ifndef __ENCRYPTION_H
#define __ENCRYPTION_H

#include <map>
#include <arpa/inet.h>
#include <asm/types.h>		// __u32
#include <openssl/blowfish.h>


typedef std::map<__u32, BF_KEY> KeyMap;


class NeighbourEncryption {
private:
	KeyMap* keyMap;
	BF_KEY myTransportKey;

	bool getKey( __u32 ip, bool force );
	bool loadTransportKey();

public:
	NeighbourEncryption();
	~NeighbourEncryption();

	unsigned int encrypt( const char* from, char* to, size_t fromlen, size_t tolen );
	unsigned int decrypt( char* buf, size_t len, size_t maxlen, sockaddr addr );
};

#endif
