/***************************************************************************
 *   Copyright (C) 2005 by Dmitry Nezhevenko                               *
 *   dion@rcom.zp.ua                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "fmpixmap.h"

#include <qstring.h>
#include <qpixmap.h>

fmPixmap::fmPixmap(QObject *parent, const char *name)
		: QObject(parent, name)
{}


fmPixmap::~fmPixmap()
{}

QPixmap fmPixmap::folderPixmap(const QString& dir)
{
	if (dir=="Phone") return(QPixmap::fromMimeSource("kfm.png"));
	if (dir.contains('/')==1) return(QPixmap::fromMimeSource("drive.png"));
	if (dir.startsWith("/a/mobile/audio"))return (QPixmap::fromMimeSource("folder_sound.png"));
	if (dir.startsWith("/a/mobile/video")) return (QPixmap::fromMimeSource("folder_video.png"));
	if (dir.startsWith("/a/mobile/picture")) return (QPixmap::fromMimeSource("folder_image.png"));

	return (QPixmap::fromMimeSource("folder.png"));
}

QPixmap fmPixmap::filePixmap(const QString& fn)
{
	QString ext;
	if (!fn.contains('.')) ext=" "; else ext=fn.section('.',-1,-1);
	if ((ext=="gif") || (ext=="jpg") || (ext=="bmp") || (ext=="png")) return QPixmap::fromMimeSource("image.png");
	if ((ext=="wav") || (ext=="mid") || (ext=="mp3")) return QPixmap::fromMimeSource("sound.png");
	if ((ext=="txt")) return QPixmap::fromMimeSource("txt.png");
	if ((ext=="3gp")) return QPixmap::fromMimeSource("video.png");
	if ((ext=="ch")) return QPixmap::fromMimeSource("colorscm.png");
	return QPixmap::fromMimeSource("empty.png");
}

