/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2004 NoMachine, http://www.nomachine.com.          */
/*                                                                        */
/* NXAGENT, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

#include "Options.h"

/*
 * Instead of having a single options' repository
 * data could be attached to the display or the
 * screen. The macro nxagentOption() should make
 * the transition simple.
 */

AgentOptionsRec nxagentOptions;

AgentOptionsPtr nxagentOptionsPtr = &nxagentOptions;

/*
 * This must be called at startup to initialize
 * the options' repository to the default values.
 */

void nxagentResetOptions()
{
  nxagentOptions.Rootless   = 0;
  nxagentOptions.Fullscreen = 0;
  nxagentOptions.Persistent = 0;

  nxagentOptions.X           = 0;
  nxagentOptions.Y           = 0;
  nxagentOptions.Width       = 0;
  nxagentOptions.Height      = 0;
  nxagentOptions.BorderWidth = 0;

  nxagentOptions.Nested = 0;

  nxagentOptions.BackingStore = BackingStoreUndefined;

  nxagentOptions.SharedMemory = 1;

  nxagentOptions.DeviceControl = 0;

  nxagentOptions.Reset = 0;
}
