/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001, 2004 NoMachine, http://www.nomachine.com.          */
/*                                                                        */
/* NXAGENT, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rights reserved.                                                   */
/*                                                                        */
/**************************************************************************/

/*

Copyright 1993 by Davor Matic

Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.  Davor Matic makes no representations about
the suitability of this software for any purpose.  It is provided "as
is" without express or implied warranty.

*/

#include "scrnintstr.h"
#include "dix.h"
#include "mi.h"
#include "micmap.h"
#include "mibstore.h"
#include "colormapst.h"
#include "resource.h"
#include "mipointer.h"

#include "Agent.h"
#include "Display.h"
#include "Screen.h"
#include "Atoms.h"
#include "GC.h"
#include "GCOps.h"
#include "Drawable.h"
#include "Font.h"
#include "Color.h"
#include "Cursor.h"
#include "Visual.h"
#include "Events.h"
#include "Init.h"
#include "Args.h"
#include "Control.h"
#include "Options.h"
#include "Splash.h"

#ifdef NXAGENT_MVFB

#include "../../mfb/mfb.h"
#include "../../fb/fb.h"

#endif

#include "Xatom.h"
#include "Xproto.h"
#include "extensions/Xrender.h"

#ifdef NXAGENT_RECONNECT
#include "Keyboard.h"
#include "Pointer.h"
#endif

#ifdef NXAGENT_PACKEDIMAGES

#include NXAGENT_NXLIB_INCLUDE

extern int nxagentPackMethod;

#endif

/*
 * Set here the required log level.
 */

#define PANIC
#define WARNING
#undef  TEST
#undef  DEBUG
#undef  WATCH

#ifdef WATCH
#include "unistd.h"
#endif

extern Bool nxagentIpaq;
extern Pixmap nxagentIconPixmap;
extern Pixmap nxagentIconShape;
extern Bool useXpmIcon;

Window nxagentDefaultWindows[MAXSCREENS];
Window nxagentScreenSaverWindows[MAXSCREENS];

#ifdef NXAGENT_FORCEBACK
extern Bool nxagentForceBackingStore;
#endif

#ifdef NXAGENT_ONEXIT
Atom nxagent_WM;
#endif

#ifdef NXAGENT_ONSTART
Atom nxagent_WM_START;
Window nxagentSplashWindow = None;
Pixmap nxagentPixmapLogo;
#endif


#ifdef NXAGENT_RECONNECT
ScreenPtr nxagentDummyScreen = NULL;
int  nxagentArgc        = 0;
char**   nxagentArgv    = NULL;
#endif

#ifdef NXAGENT_ARTSD

char mcop_atom[] = "MCOPGLOBALS";
Atom mcop_local_atom = None;
unsigned char fromHexNibble(char c);
void nxagentPropagateArtsdProperties(ScreenPtr pScreen, char *port);

#endif

#ifdef NXAGENT_FAKEBS
extern BSFuncRec nxBSFuncRec;
/*
extern void nxSaveDoomedAreas (WindowPtr pWin,
                        RegionPtr pObscured,
                               int dx, int dy);
extern RegionPtr nxRestoreDoomedAreas (WindowPtr pWin,
RegionPtr prgnExposed);
*/
#endif

#ifdef RENDER
Bool nxagentRenderEnable = True;
extern Bool nxagentAlphaEnabled;
extern Bool nxagentPictureInit(ScreenPtr, PictFormatPtr, int);
#endif

#ifdef NXAGENT_FULLSCREEN
Window nxagentIconWindow;
Window nxagentFullscreenWindow;

void MinimizeFromFullScreen(ScreenPtr pScreen)
{
    XUnmapWindow(nxagentDisplay, nxagentFullscreenWindow);
    if(nxagentIpaq)
    {
        XMapWindow(nxagentDisplay, nxagentIconWindow);
        XIconifyWindow(nxagentDisplay, nxagentIconWindow,
                       DefaultScreen(nxagentDisplay));
    }
    else
    {
        XIconifyWindow(nxagentDisplay, nxagentIconWindow,
                       DefaultScreen(nxagentDisplay));

    }
}

void MaximizeToFullScreen(ScreenPtr pScreen)
{
    if(nxagentIpaq)
    {
        XUnmapWindow(nxagentDisplay, nxagentIconWindow);
        XMapWindow(nxagentDisplay, nxagentFullscreenWindow);
    }
    else
    {
/*
        XUnmapWindow(nxagentDisplay, nxagentIconWindow);
*/
        XMapRaised(nxagentDisplay, nxagentFullscreenWindow);
        XIconifyWindow(nxagentDisplay, nxagentIconWindow,
                       DefaultScreen(nxagentDisplay));
/*
        XMapWindow(nxagentDisplay, nxagentIconWindow);
*/

    }

}

Bool magicPixelZone(int x, int y)
{
  return (x >= nxagentOption(Width) - 1 && y < 1);
}

#endif

ScreenPtr nxagentScreen(window)
     Window window;
{
  int i;

  for (i = 0; i < nxagentNumScreens; i++)
    if (nxagentDefaultWindows[i] == window)
      return screenInfo.screens[i];

  return NULL;
}

static int offset(mask)
     unsigned long mask;
{
  int count;

  for (count = 0; !(mask & 1) && count < 32; count++)
    mask >>= 1;

  return count;
}

static Bool nxagentSaveScreen(pScreen, what)
     ScreenPtr pScreen;
     int what;
{
#ifdef NXAGENT_NEVERSS
    return True;
#endif
  if (nxagentSoftwareScreenSaver)
    return False;
  else {
    switch (what) {
    case SCREEN_SAVER_ON:
      XMapRaised(nxagentDisplay, nxagentScreenSaverWindows[pScreen->myNum]);
      nxagentSetScreenSaverColormapWindow(pScreen);
      break;
      
    case SCREEN_SAVER_OFF:
      XUnmapWindow(nxagentDisplay, nxagentScreenSaverWindows[pScreen->myNum]);
      nxagentSetInstalledColormapWindows(pScreen);
      break;
      
    case SCREEN_SAVER_FORCER:
      nxagentLastEventTime = GetTimeInMillis();
      XUnmapWindow(nxagentDisplay, nxagentScreenSaverWindows[pScreen->myNum]);
      nxagentSetInstalledColormapWindows(pScreen);
      break;
      
    case SCREEN_SAVER_CYCLE:
      XUnmapWindow(nxagentDisplay, nxagentScreenSaverWindows[pScreen->myNum]);
      nxagentSetInstalledColormapWindows(pScreen);
      break;
    }
    return True;
  }
}

static Bool
nxagentCursorOffScreen (ppScreen, x, y)
    ScreenPtr   *ppScreen;
    int         *x, *y;
{
    return FALSE;
}

static void
nxagentCrossScreen (pScreen, entering)
    ScreenPtr   pScreen;
    Bool        entering;
{
}

static miPointerScreenFuncRec nxagentPointerCursorFuncs =
{
    nxagentCursorOffScreen,
    nxagentCrossScreen,
    miPointerWarpCursor
};

Bool nxagentOpenScreen(index, pScreen, argc, argv)
     int index;
     register ScreenPtr pScreen;
     int argc;
     char *argv[];
{
  VisualPtr visuals;
  DepthPtr depths;
  int numVisuals, numDepths;
  int i, j, depthIndex;
  unsigned long valuemask;
  XSetWindowAttributes attributes;
  XWindowAttributes gattributes;
  XSizeHints sizeHints;
  XWMHints wmHints;


  #if defined(NXAGENT_STOPBIGREQ) || defined(NXAGENT_GETIFOCUS)
  extern int nxagentClientPrivateIndex;
  #endif

  #ifdef TEST
  fprintf(stderr, "nxagentOpenScreen: Called for screen index [%d].\n",
              index);
  #endif

#ifdef NXAGENT_RECONNECT
  if (nxagentOption(Persistent))
  {
    nxagentDummyScreen = pScreen;
    nxagentArgc   = argc;
    nxagentArgv   = argv;
  }
#endif

#ifdef NXAGENT_TIMESTAMP
{
  extern unsigned long startTime;
  fprintf(stderr, "Screen: going to open screen, time is [%d] milliseconds.\n",
          GetTimeInMillis() - startTime);
}
#endif

  if (!(AllocateWindowPrivate(pScreen, nxagentWindowPrivateIndex, sizeof(nxagentPrivWin))  &&
        AllocateGCPrivate(pScreen, nxagentGCPrivateIndex, sizeof(nxagentPrivGC)) &&
#if defined(NXAGENT_STOPBIGREQ) || defined(NXAGENT_GETIFOCUS)
        /* allocate only the pointer */
        AllocateClientPrivate(nxagentClientPrivateIndex, sizeof(nxagentPrivClient)))
#endif
      )
    return False;

#ifdef NXAGENT_MVFB
  {
    extern Bool fbAllocatePrivates(ScreenPtr, int *);
    if (!fbAllocatePrivates(pScreen, &i) ||
        !AllocatePixmapPrivate(pScreen, nxagentPixmapPrivateIndex, sizeof(nxagentPrivPixmapRec)) ||
         !AllocateGCPrivate(pScreen, mfbGCPrivateIndex, sizeof(mfbPrivGC)))
      return False;
  }
#else
   if (!AllocatePixmapPrivate(pScreen, nxagentPixmapPrivateIndex, sizeof(nxagentPrivPixmapRec)))
     return False;  
#endif

  /*
   * Initialize the depths.
   */

  depths = (DepthPtr) xalloc(nxagentNumDepths * sizeof(DepthRec));

  for (i = 0; i < nxagentNumDepths; i++)
  {
    depths[i].depth = nxagentDepths[i];
    depths[i].numVids = 0;
    depths[i].vids = (VisualID *) xalloc(MAXVISUALSPERDEPTH * sizeof(VisualID));
  }

  /*
   * Initialize the visuals.
   */

  numVisuals = 0;
  numDepths = nxagentNumDepths;

  visuals = (VisualPtr) xalloc(nxagentNumVisuals * sizeof(VisualRec));

  for (i = 0; i < nxagentNumVisuals; i++)
  {
    visuals[numVisuals].vid = FakeClientID(0);
    visuals[numVisuals].class = nxagentVisuals[i].class;
    visuals[numVisuals].bitsPerRGBValue = nxagentVisuals[i].bits_per_rgb;
    visuals[numVisuals].ColormapEntries = nxagentVisuals[i].colormap_size;
    visuals[numVisuals].nplanes = nxagentVisuals[i].depth;
    visuals[numVisuals].redMask = nxagentVisuals[i].red_mask;
    visuals[numVisuals].greenMask = nxagentVisuals[i].green_mask;
    visuals[numVisuals].blueMask = nxagentVisuals[i].blue_mask;
    visuals[numVisuals].offsetRed = offset(nxagentVisuals[i].red_mask);
    visuals[numVisuals].offsetGreen = offset(nxagentVisuals[i].green_mask);
    visuals[numVisuals].offsetBlue = offset(nxagentVisuals[i].blue_mask);

    depthIndex = UNDEFINED;

    for (j = 0; j < numDepths; j++)
    {
      if (depths[j].depth == nxagentVisuals[i].depth)
      {
        depthIndex = j;
        break;
      }
    }

    if (depthIndex == UNDEFINED)
    {
      #ifdef WARNING
      fprintf(stderr, "nxagentOpenScreen: WARNING! Can't find a matching depth for visual depth [%d].\n",
              nxagentVisuals[i].depth);
      #endif

      depthIndex = numDepths;

      depths[depthIndex].depth = nxagentVisuals[i].depth;
      depths[depthIndex].numVids = 0;
      depths[depthIndex].vids = (VisualID *) xalloc(MAXVISUALSPERDEPTH * sizeof(VisualID));

      numDepths++;
    }

    if (depths[depthIndex].numVids >= MAXVISUALSPERDEPTH)
    {
      FatalError("Visual table overflow");
    }

    depths[depthIndex].vids[depths[depthIndex].numVids] = visuals[numVisuals].vid;

    depths[depthIndex].numVids++;

    numVisuals++;
  }

  #ifdef WATCH

  fprintf(stderr, "nxagentOpenScreen: Watchpoint 7.\n");

/*
Reply   Total	Cached	Bits In			Bits Out		Bits/Reply	  Ratio
------- -----	------	-------			--------		----------	  -----
N/A
*/

  sleep(30);

  #endif

  if (nxagentParentWindow != 0)
  {
    /*
     * This would cause a GetWindowAttributes
     * and a GetGeometry (asynchronous) reply.
     */

    XGetWindowAttributes(nxagentDisplay, nxagentParentWindow, &gattributes);

    nxagentChangeOption(Width, gattributes.width);
    nxagentChangeOption(Height, gattributes.height);
  }

  #ifdef NXAGENT_PACKEDIMAGES

  /*
   * Inform nxproxy about how to unpack
   * images for a given depth.
   */

  if (nxagentPackMethod != -1)
  {
    /*
     * FIXME: Must carry the agent's client.
     */

    NXSetUnpackGeometry(nxagentDisplay, 0, DefaultScreenOfDisplay(nxagentDisplay), NULL);
  }

  #endif

  /*
   * Determine the size of the root window.
   * It is the maximum size of the screen
   * if we are either in rootless or in
   * fullscreen mode.
   */

  if (nxagentOption(Rootless) || nxagentOption(Fullscreen))
  {
    nxagentChangeOption(X, 0);
    nxagentChangeOption(Y, 0);

    nxagentChangeOption(Width,  WidthOfScreen(DefaultScreenOfDisplay(nxagentDisplay)));
    nxagentChangeOption(Height, HeightOfScreen(DefaultScreenOfDisplay(nxagentDisplay)));

    nxagentChangeOption(BorderWidth, 0);
  }

  if (nxagentOption(Fullscreen))
  {
    attributes.override_redirect = True;

    /*
     * We need to disable the host's screensaver or
     * it will otherwise grab the screen even if it
     * is under agent's control.
     */

    XSetScreenSaver(nxagentDisplay, 0, 0, DefaultExposures, DefaultBlanking);
  }

  #ifdef NXAGENT_MVFB

  {
    extern Bool nxagentTrue24;

    if (nxagentTrue24)
    {
        fbGetScreenPrivate(pScreen)->win32bpp = visuals[nxagentDefaultVisualIndex].nplanes;
        fbGetScreenPrivate(pScreen)->pix32bpp = visuals[nxagentDefaultVisualIndex].nplanes;
    }
    else
    {
        fbGetScreenPrivate(pScreen)->win32bpp = 32;
        fbGetScreenPrivate(pScreen)->pix32bpp = 32;
    }
  }

  #endif

  /* myNum */
  /* id */
  miScreenInit(pScreen, NULL, nxagentOption(Width),
               nxagentOption(Height), 1, 1, nxagentOption(Width),
               visuals[nxagentDefaultVisualIndex].nplanes, /* rootDepth */
               numDepths, depths,
               visuals[nxagentDefaultVisualIndex].vid, /* root visual */
               numVisuals, visuals);

#ifndef NXAGENT_FAKEBS
  /*miInitializeBackingStore(pScreen);*/
#endif

  /*
   * From misprite.c: called from device-dependent screen
   * initialization proc after all of the function pointers
   * have been stored in the screen structure.
   */

  miDCInitialize(pScreen, &nxagentPointerCursorFuncs);

  pScreen->mmWidth = nxagentOption(Width) *
                         DisplayWidthMM(nxagentDisplay,
                             DefaultScreen(nxagentDisplay)) /
                                 DisplayWidth(nxagentDisplay,
                                     DefaultScreen(nxagentDisplay));

  pScreen->mmHeight = nxagentOption(Height) *
                          DisplayHeightMM(nxagentDisplay,
                              DefaultScreen(nxagentDisplay)) /
                                  DisplayHeight(nxagentDisplay,
                                      DefaultScreen(nxagentDisplay));

  pScreen->defColormap = (Colormap) FakeClientID(0);
  pScreen->minInstalledCmaps = MINCMAPS;
  pScreen->maxInstalledCmaps = MAXCMAPS;
#ifdef NXAGENT_BAKSTR
  pScreen->backingStoreSupport = nxagentBackingStore;
  pScreen->saveUnderSupport = nxagentSaveUnder;
#else
  pScreen->backingStoreSupport = NotUseful;
  pScreen->saveUnderSupport = NotUseful;
#endif
  pScreen->whitePixel = nxagentWhitePixel;
  pScreen->blackPixel = nxagentBlackPixel;
  /* rgf */
  /* GCperDepth */
  /* PixmapPerDepth */
  pScreen->devPrivate = NULL;
  /* WindowPrivateLen */
  /* WindowPrivateSizes */
  /* totalWindowSize */
  /* GCPrivateLen */
  /* GCPrivateSizes */
  /* totalGCSize */

  /*
   * Random screen procedures.
   */

  pScreen->CloseScreen = nxagentCloseScreen;
  pScreen->QueryBestSize = nxagentQueryBestSize;
  pScreen->SaveScreen = nxagentSaveScreen;
  pScreen->GetImage = nxagentGetImage;
  pScreen->GetSpans = nxagentGetSpans;
  pScreen->PointerNonInterestBox = (void (*)()) 0;
  pScreen->SourceValidate = (void (*)()) 0;

  /*
   * Window Procedures.
   * 
   * Note that the following functions are not
   * replaced with nxagent counterparts:
   *
   * ValidateTreeProcPtr       ValidateTree;
   * ClearToBackgroundProcPtr  ClearToBackground;
   *
   * Note also that the ConfigureWindow procedure
   * has not a pointer in the screen structure.
   */

  pScreen->CreateWindow = nxagentCreateWindow;
  pScreen->DestroyWindow = nxagentDestroyWindow;
  pScreen->PositionWindow = nxagentPositionWindow;
  pScreen->ChangeWindowAttributes = nxagentChangeWindowAttributes;
  pScreen->RealizeWindow = nxagentRealizeWindow;
  pScreen->UnrealizeWindow = nxagentUnrealizeWindow;
  pScreen->PostValidateTree = (void (*)()) 0;
  pScreen->WindowExposures = nxagentWindowExposures;
  pScreen->PaintWindowBackground = nxagentPaintWindowBackground;
  pScreen->PaintWindowBorder = nxagentPaintWindowBorder;
  pScreen->CopyWindow = nxagentCopyWindow;
  pScreen->ClipNotify = nxagentClipNotify;
  pScreen->RestackWindow = nxagentRestackWindow;

  /*
   * Pixmap procedures.
   */

  pScreen->CreatePixmap = nxagentCreatePixmap;
  pScreen->DestroyPixmap = nxagentDestroyPixmap;

  /*
   * Backing store procedures.
   */

  #ifdef NXAGENT_FAKEBS

  pScreen->BackingStoreFuncs = nxBSFuncRec;
  miInitializeBackingStore(pScreen);

  #else

  pScreen->SaveDoomedAreas = (void (*)()) 0;
  pScreen->RestoreAreas = (RegionPtr (*)()) 0;
  pScreen->ExposeCopy = (void (*)()) 0;
  pScreen->TranslateBackingStore = (RegionPtr (*)()) 0;
  pScreen->ClearBackingStore = (RegionPtr (*)()) 0;
  pScreen->DrawGuarantee = (void (*)()) 0;

  #endif

  /*
   * Font procedures.
   */

  pScreen->RealizeFont = nxagentRealizeFont;
  pScreen->UnrealizeFont = nxagentUnrealizeFont;

  /*
   * Cursor Procedures.
   */

  pScreen->ConstrainCursor = nxagentConstrainCursor;
  pScreen->CursorLimits = nxagentCursorLimits;
  pScreen->DisplayCursor = nxagentDisplayCursor;
  pScreen->RealizeCursor = nxagentRealizeCursor;
  pScreen->UnrealizeCursor = nxagentUnrealizeCursor;
  pScreen->RecolorCursor = nxagentRecolorCursor;
  pScreen->SetCursorPosition = nxagentSetCursorPosition;

  /*
   * GC procedures.
   */

  pScreen->CreateGC = nxagentCreateGC;

  /*
   * Colormap procedures.
   */

  pScreen->CreateColormap = nxagentCreateColormap;
  pScreen->DestroyColormap = nxagentDestroyColormap;
  pScreen->InstallColormap = nxagentInstallColormap;
  pScreen->UninstallColormap = nxagentUninstallColormap;
  pScreen->ListInstalledColormaps = nxagentListInstalledColormaps;
  pScreen->StoreColors = nxagentStoreColors;
  pScreen->ResolveColor = nxagentResolveColor;

  pScreen->BitmapToRegion = nxagentPixmapToRegion;

  /*
   * OS layer procedures.
   */

  pScreen->BlockHandler = (void (*)())NoopDDA;
  pScreen->WakeupHandler = (void (*)())NoopDDA;
  pScreen->blockData = (pointer)0;
  pScreen->wakeupData = (pointer)0;

  /*
   * Initialization of devPrivates.
   */

  if (!miScreenDevPrivateInit(pScreen, nxagentOption(Width), NULL))
    return FALSE;

#define POSITION_OFFSET (pScreen->myNum * (nxagentOption(Width) + \
                             nxagentOption(Height)) / 32)

#ifdef NXAGENT_FORCEBACK
    {
        int i = XDoesBackingStore(DefaultScreenOfDisplay(nxagentDisplay));
        switch(i)
        {
        case Always:
#ifdef NXAGENT_FORCEBACK_DEBUG
            fprintf(stderr, "DOES BACKING STORE: Always\n");
#endif
            if (nxagentOption(Fullscreen))
            {
                nxagentForceBackingStore = False;
            }
            break;
        case NotUseful:
#ifdef NXAGENT_FORCEBACK_DEBUG
            fprintf(stderr, "DOES BACKING STORE: NotUseful\n");
#endif
            nxagentForceBackingStore = False;
            break;
        case WhenMapped:
#ifdef NXAGENT_FORCEBACK_DEBUG
            fprintf(stderr, "DOES BACKING STORE: WhenMapped\n");
#endif
            break;
        }
    }
#endif

  if (nxagentDoFullGeneration)
  {
    nxagentEventMask |= FocusChangeMask;
    valuemask = CWBackPixel | CWEventMask | CWColormap | (nxagentOption(Fullscreen)?CWOverrideRedirect:0);
    attributes.background_pixel = nxagentBlackPixel;
    attributes.event_mask = nxagentEventMask;
    attributes.colormap = nxagentDefaultVisualColormap(nxagentDefaultVisual(pScreen));
#ifdef NXAGENT_FULLSCREEN
    if(nxagentOption(Fullscreen)){
        attributes.override_redirect = True;
    }
#endif

    /*
     * This would be used when running agent
     * embedded into another X window.
     */

    if (nxagentParentWindow != 0)
    {
      nxagentDefaultWindows[pScreen->myNum] = nxagentParentWindow;

      XSelectInput(nxagentDisplay, nxagentDefaultWindows[pScreen->myNum],
                       nxagentEventMask);
    }
    else
    {
      /*
       * Create any top-level window as a child of the
       * real root of the remote display. See also the
       * InitRootWindow() procedure and the function
       * handling the splash screen.
       */

      if (nxagentOption(Rootless) == True)
      {
        nxagentDefaultWindows[pScreen->myNum] = DefaultRootWindow(nxagentDisplay);

        #ifdef TEST
        fprintf(stderr, "nxagentOpenScreen: Using root window id [%ld].\n",
                    nxagentDefaultWindows[pScreen->myNum]);
        #endif
      }

      #ifdef TEST
      fprintf(stderr, "nxagentOpenScreen: Going to create new default window.\n");
      #endif

      nxagentDefaultWindows[pScreen->myNum] =
          XCreateWindow(nxagentDisplay,
                        DefaultRootWindow(nxagentDisplay),
                        nxagentOption(X) + POSITION_OFFSET,
                        nxagentOption(Y) + POSITION_OFFSET,
                        nxagentOption(Width),
                        nxagentOption(Height),
                        nxagentOption(BorderWidth),
                        pScreen->rootDepth,
                        InputOutput,
                        nxagentDefaultVisual(pScreen),
                        valuemask, &attributes);

      #ifdef TEST
      fprintf(stderr, "nxagentOpenScreen: Created new default window with id [%ld].\n",
                  nxagentDefaultWindows[pScreen->myNum]);
      #endif

      /*
       * The purpose is to use a single round-trip
       * to get all the intern atoms.
       */

      nxagentQueryAtoms(pScreen);

      #ifdef NXAGENT_FULLSCREEN

      if (nxagentOption(Fullscreen))
      {
        nxagentFullscreenWindow = nxagentDefaultWindows[pScreen->myNum];
      }

      if (nxagentIpaq)
      {
        XWindowChanges ch;
        unsigned int ch_mask;

        ch.stack_mode = Below;
        ch_mask = CWStackMode;

        XConfigureWindow(nxagentDisplay, nxagentFullscreenWindow, ch_mask, &ch);
      }

      #endif
    }

#ifdef NXAGENT_FULLSCREEN

    if (nxagentOption(Fullscreen))
    {
      /*
       * FIXME: Do we still need to set this property?
       */

      if (nxagentAtoms[8] != 0)
      {
        XChangeProperty(nxagentDisplay,
                        nxagentDefaultWindows[pScreen->myNum],
                        nxagentAtoms[8], /* NX_AGENT_SIGNATURE */
                        XA_STRING,
                        8, 
                        PropModeReplace, 
                        (unsigned char*) "X-AGENT",
                        strlen("X-AGENT"));
      }

      nxagentEventMask |= EnterWindowMask | LeaveWindowMask;
      nxagentEventMask |= KeyPressMask | KeyReleaseMask | ButtonPressMask | ButtonReleaseMask;

      XSelectInput(nxagentDisplay, nxagentFullscreenWindow,
                       nxagentEventMask);
    }

#endif

#ifdef NXAGENT_REPARENT_DEBUG
    fprintf(stderr, "root window ID: %X\n",
            nxagentDefaultWindows[pScreen->myNum]);
#endif

#ifdef NXAGENT_REPARENT
    /* we want to know where the pointer is */
    XSelectInput (nxagentDisplay, DefaultRootWindow(nxagentDisplay),
                  PointerMotionMask | KeyPressMask | KeyReleaseMask | KeymapStateMask);
/*                   ButtonPressMask | ButtonReleaseMask | PointerMotionMask */
/*                   KeyPressMask | KeyReleaseMask | KeymapStateMask */
/*                   PointerMotionMask */
#endif

    sizeHints.flags = PPosition | PMinSize | PMaxSize;
    sizeHints.x = nxagentOption(X) + POSITION_OFFSET;
    sizeHints.y = nxagentOption(Y) + POSITION_OFFSET;
    sizeHints.width = sizeHints.max_width = sizeHints.min_width = nxagentOption(Width);
    sizeHints.height = sizeHints.max_height = sizeHints.min_height = nxagentOption(Height);
    if (nxagentUserGeometry & XValue || nxagentUserGeometry & YValue)
      sizeHints.flags |= USPosition;
    if (nxagentUserGeometry & WidthValue || nxagentUserGeometry & HeightValue)
      sizeHints.flags |= USSize;

    XSetStandardProperties(nxagentDisplay,
                           nxagentDefaultWindows[pScreen->myNum],
                           nxagentWindowName,
                           nxagentWindowName,
                           nxagentIconPixmap,
                           argv, argc, &sizeHints);

    wmHints.icon_pixmap = nxagentIconPixmap;

    if (useXpmIcon)
    {
      wmHints.icon_mask = nxagentIconShape;
      wmHints.flags = IconPixmapHint | IconMaskHint;
    }
    else
    {
      wmHints.flags = IconPixmapHint;
    }

    XSetWMHints(nxagentDisplay, nxagentDefaultWindows[pScreen->myNum], &wmHints);

    /*
     * Clear the window but let it unmapped. We'll map it
     * at the time the we'll initialize our screen root
     * and only if we are not running in rootless mode.
     */

    XClearWindow(nxagentDisplay, nxagentDefaultWindows[pScreen->myNum]);

#ifdef NXAGENT_FULLSCREEN

    if (nxagentOption(Fullscreen))
    {
      valuemask = CWBackPixmap | CWColormap | CWOverrideRedirect;
    }
    else
    {
      valuemask = CWBackPixmap | CWColormap;
    }

#else

    valuemask = CWBackPixmap | CWColormap;

#endif

    attributes.background_pixmap = nxagentScreenSaverPixmap;
    attributes.colormap = DefaultColormap(nxagentDisplay, DefaultScreen(nxagentDisplay));

#ifdef NXAGENT_FULLSCREEN

    if (nxagentOption(Fullscreen))
    {
      attributes.override_redirect = False;
    }

#endif

#ifdef NXAGENT_FULLSCREEN

    if (nxagentOption(Fullscreen))
    {
      attributes.override_redirect = False;

      valuemask |= CWOverrideRedirect;

      #ifdef TEST
      fprintf(stderr, "nxagentOpenScreen: Going to create new icon window.\n");
      #endif

      nxagentIconWindow =
          XCreateWindow(nxagentDisplay,
                        DefaultRootWindow(nxagentDisplay),
                        0, 0, 1, 1, 0,
                        DefaultDepth(nxagentDisplay, DefaultScreen(nxagentDisplay)),
                        InputOutput,
                        DefaultVisual(nxagentDisplay, DefaultScreen(nxagentDisplay)),
                        valuemask, &attributes);

      #ifdef TEST
      fprintf(stderr, "nxagentOpenScreen: Created new icon window with id [%ld].\n",
                  nxagentIconWindow);
      #endif
    }

#endif

#ifndef NXAGENT_NEVERSS

    #ifdef TEST
    fprintf(stderr, "nxagentOpenScreen: Going to create new screen saver window.\n");
    #endif

    nxagentScreenSaverWindows[pScreen->myNum] =
        XCreateWindow(nxagentDisplay,
                      nxagentDefaultWindows[pScreen->myNum],
                      0, 0, nxagentOption(Width), nxagentOption(Height), 0,
                      DefaultDepth(nxagentDisplay, DefaultScreen(nxagentDisplay)),
                      InputOutput,
                      DefaultVisual(nxagentDisplay, DefaultScreen(nxagentDisplay)),
                      valuemask, &attributes);

    #ifdef TEST
    fprintf(stderr, "nxagentOpenScreen: Created new screen saver window with id [%ld].\n",
                nxagentScreenSaverWindows[pScreen->myNum]);
    #endif

#endif

#ifdef NXAGENT_FULLSCREEN

    if (nxagentOption(Fullscreen))
    {
      sizeHints.flags = PMinSize | PMaxSize;
      sizeHints.min_width = sizeHints.max_height = 1;
      sizeHints.min_height = sizeHints.max_height = 1;

      XSetStandardProperties(nxagentDisplay,
                             nxagentIconWindow,
                             nxagentWindowName,
                             nxagentWindowName,
                             nxagentIconPixmap,
                             0, 0, &sizeHints);

      /*
       * Start helper window in iconified state.
       */

      wmHints.flags = IconPixmapHint | IconMaskHint;
      wmHints.initial_state = IconicState;
      wmHints.icon_pixmap = nxagentIconPixmap;

      if (useXpmIcon) 
      {              
        wmHints.icon_mask = nxagentIconShape;
        wmHints.flags = IconPixmapHint | IconMaskHint;
      }
      else
      {
        wmHints.flags = StateHint | IconPixmapHint;
      }

      XSetWMHints(nxagentDisplay, nxagentIconWindow, &wmHints);

      XSelectInput(nxagentDisplay, nxagentIconWindow,
                       (nxagentEventMask & ~(KeyPressMask | KeyReleaseMask)) | StructureNotifyMask);

      /*
       * Assume that we will always receive an EnterNotify
       * event as soon as the fullscreen window is mapped.
       * This allows us to save two roundtrips.
       *
       * nxagentGrabPointerAndKeyboard(NULL);
       */       
    }

#endif

  }

  if (!nxagentCreateDefaultColormap(pScreen))
  {
    #ifdef PANIC
    fprintf(stderr, "nxagentOpenScreen: Failed to create default colormap for screen.\n");
    #endif

    return False;
  }

  /*
   * The purpose of this check is to verify if there
   * is a window manager running. Unfortunately due
   * to the way we manage the intern atoms call, the
   * atom will always exist.
   */

  if (nxagent_WM != None)  /* WM_PROTOCOLS */
  {
    Atom deleteWMatom = nxagentAtoms[2];  /* WM_DELETE_WINDOW */

    #ifdef TEST
    fprintf(stderr, "nxagentOpenScreen: Found WM with atom [%ld] and delete window atom [%ld].\n",
                nxagent_WM, deleteWMatom);
    #endif

    if (nxagentOption(Rootless) == False)
    {
      /*
       * Set the WM_DELETE_WINDOW protocol for the main agent
       * window and, if we are in fullscreen mode, include the
       * icon window.
       */

      XSetWMProtocols(nxagentDisplay, nxagentDefaultWindows[pScreen->myNum], &deleteWMatom, 1);

      if (nxagentOption(Fullscreen))
      {
        XSetWMProtocols(nxagentDisplay, nxagentIconWindow, &deleteWMatom, 1);
      }
    }
    else
    {
      /*
       * We need to register the ICCCM WM_DELETE_WINDOW protocol
       * for any top-level window or the agent will be killed if
       * any window is closed.
       */

      fprintf(stderr, "Warning: Not setting the WM_DELETE_WINDOW protocol.\n");
    }
  }
  else
  {
    /*
     * We should always enable configuration of the remote
     * X server's devices if we are running fullscreen and
     * there is no WM running.
     */

    if (nxagentOption(Fullscreen))
    {
      #ifdef TEST
      fprintf(stderr, "nxagentOpenScreen: WARNING! Forcing propagation of device control changes.\n");
      #endif

      nxagentChangeOption(DeviceControl, True);
    }
  }

  /*
   * Inform user if agent's clients will be able to
   * change the real X server's keyboard and pointer
   * settings.
   */

  if (nxagentOption(DeviceControl) == False)
  {
    fprintf(stderr, "Info: Not using local device configuration changes.\n");
  }
  else
  {
    fprintf(stderr, "Info: Using local device configuration changes.\n");
  }

#ifdef RENDER

  if (nxagentRenderEnable)
  {
    int major_opcode, first_event, first_error;
    int major_version, minor_version;

    if (XQueryExtension(nxagentDisplay, "RENDER", &major_opcode, &first_event, &first_error))
    {
      XRenderQueryVersion(nxagentDisplay, &major_version, &minor_version);

      if ((major_version == 0) && (minor_version < 2))
      {
        fprintf(stderr, "Warning: Incompatible render version detected in X server.\n");

        nxagentRenderEnable = False;
      }
      else
      {
        fprintf(stderr, "Info: Using render extension support in X server.\n");

        if (!nxagentPictureInit(pScreen, 0, 0))
        {
          nxagentRenderEnable = False;              

          return FALSE;
        }

        if (nxagentAlphaEnabled)
        {
          fprintf(stderr, "Info: Using alpha channel in render extension.\n");
        }
      }
    }
    else
    {
      fprintf(stderr, "Warning: Render extension not available in X server.\n");

      nxagentRenderEnable = False;
    }        
  }

#endif /* RENDER */

#ifdef NXAGENT_ONSTART
  nxagent_WM_START = nxagentAtoms[3];  /* WM_NX_READY */
#endif

#ifdef NXAGENT_TIMESTAMP
{
  extern unsigned long startTime;

  fprintf(stderr, "Screen: open screen finished, time is [%d] milliseconds.\n",
          GetTimeInMillis() - startTime);
}
#endif

  #ifdef WATCH

  fprintf(stderr, "nxagentOpenScreen: Watchpoint 8.\n");

/*
Reply   Total	Cached	Bits In			Bits Out		Bits/Reply	  Ratio
------- -----	------	-------			--------		----------	  -----
#1   U  2	1	5344 bits (1 KB) ->	2344 bits (0 KB) ->	2672/1 -> 1172/1	= 2.280:1
#16     11		2816 bits (0 KB) ->	197 bits (0 KB) ->	256/1 -> 18/1	= 14.294:1
#91     1		16640 bits (2 KB) ->	12314 bits (2 KB) ->	16640/1 -> 12314/1	= 1.351:1
#98     2		512 bits (0 KB) ->	57 bits (0 KB) ->	256/1 -> 28/1	= 8.982:1
*/

  sleep(30);

  #endif

  return True;
}

Bool nxagentCloseScreen(index, pScreen)
     int index;
     ScreenPtr pScreen;
{
  int i;

  for (i = 0; i < pScreen->numDepths; i++)
  {
    xfree(pScreen->allowedDepths[i].vids);
  }

  xfree(pScreen->allowedDepths);
  xfree(pScreen->visuals);
  xfree(pScreen->devPrivate);

  if (nxagentLastGetImage)
  {
    #ifdef TEST
    fprintf(stderr, "nxagentGetImage: Deleting last image collected from real server.\n");
    #endif

    XDestroyImage(nxagentLastGetImage);

    nxagentLastGetImage = NULL;
  }

  /*
   * Reset the geometry and alpha information
   * used by proxy to unpack the packed images.
   */

  nxagentResetVisualCache();

  nxagentResetAlphaCache();

  /*
   * The assumption is that all X resources will be
   * destroyed upon closing the display connection.
   * There is no need to generate extra protocol.
   */

  return True;
}

void nxagentMapDefaultWindows(ScreenPtr pScreen, WindowPtr pWin, ClientPtr pClient)
{
  if (!nxagentOption(Rootless))
  {
    /*
     * Show the NX splash screen.
     */

    #ifdef TEST
    fprintf(stderr, "nxagentMapDefaultWindows: Showing the splash window.\n");
    #endif

    nxagentShowSplash(nxagentWindow(pWin));
  }

  /*
   * Map the default window.
   */

  if (!nxagentOption(Rootless))
  {
    #ifdef TEST
    fprintf(stderr, "nxagentMapDefaultWindows: Mapping default window id [%ld].\n",
                nxagentDefaultWindows[pScreen->myNum]);
    #endif

    XMapWindow(nxagentDisplay, nxagentDefaultWindows[pScreen->myNum]);
  }

  /*
   * Map the root window.
   */
 
  #ifdef TEST
  fprintf(stderr, "nxagentMapDefaultWindows: Mapping root window id [%ld].\n",
              nxagentWindow(pWin));
  #endif

  MapWindow(pWin, pClient);

  /*
   * Map the icon window.
   */

  if (nxagentIconWindow != 0)
  {
    #ifdef TEST
    fprintf(stderr, "nxagentMapDefaultWindows: Mapping icon window id [%ld].\n",
                nxagentIconWindow);
    #endif

    XMapWindow(nxagentDisplay, nxagentIconWindow);

    if(nxagentIpaq)
    {
      XIconifyWindow(nxagentDisplay, nxagentIconWindow,
                         DefaultScreen(nxagentDisplay));
    }
  }

  /*
   * Ensure that the fullscreen window gets the focus.
   */

  XSetInputFocus(nxagentDisplay, nxagentFullscreenWindow,
                     RevertToParent, CurrentTime);

  #ifdef TEST
  fprintf(stderr, "nxagentMapDefaultWindows: Completed mapping of default windows.\n");
  #endif
}

#ifdef NXAGENT_ARTSD

unsigned char fromHexNibble(char c)
{
  int uc = (unsigned char)c;

  if(uc >= '0' && uc <= '9') return uc - (unsigned char)'0';
  if(uc >= 'a' && uc <= 'f') return uc + 10 - (unsigned char)'a';
  if(uc >= 'A' && uc <= 'F') return uc + 10 - (unsigned char)'A';

  return 16; /*error*/
}

void nxagentPropagateArtsdProperties(ScreenPtr pScreen, char *port)
{
  Window                rootWin;
  Atom                  atomReturnType;
  Atom                  prop_atom;
  int                   iReturnFormat;
  unsigned long         ulReturnItems;
  unsigned long         ulReturnBytesLeft;
  unsigned char         *pszReturnData = NULL;
  int                   iReturn;

  int i,in;
  char tchar[] = "    ";
  char *chport;
  char hex[] = "0123456789abcdef";

  rootWin = DefaultRootWindow(nxagentDisplay);
  prop_atom = nxagentAtoms[4];  /* MCOPGLOBALS */

  /*
   * Get at most 64KB of data.
   */

  iReturn = XGetWindowProperty(nxagentDisplay,
                               rootWin,
                               prop_atom,
                               0,
                               65536 / 4,
                               False,
                               XA_STRING,
                               &atomReturnType,
                               &iReturnFormat,
                               &ulReturnItems,
                               &ulReturnBytesLeft,
                               &pszReturnData);

  if (iReturn == Success && atomReturnType != None &&
          ulReturnItems > 0 && pszReturnData != NULL)
  {
    char *local_buf;

    #ifdef TEST
    fprintf(stderr, "nxagentPropagateArtsdProperties: Got [%ld] elements of format [%d] with [%ld] bytes left.\n",
                ulReturnItems, iReturnFormat, ulReturnBytesLeft);
    #endif

    #ifdef WARNING

    if (ulReturnBytesLeft > 0)
    {
      fprintf(stderr, "nxagentPropagateArtsdProperties: WARNING! Could not get the whole ARTSD property data.\n");
    }

    #endif

    local_buf = (char *) xalloc(strlen((char*)pszReturnData) + 100);

    if (local_buf)
    {
      memset(local_buf, 0, strlen((char *) pszReturnData));

      for (i = 0, in = 0; pszReturnData[i] != '\0'; i++)
      {
        local_buf[in]=pszReturnData[i];

        if(pszReturnData[i]==':')
        {
          i++;

          while(pszReturnData[i]!='\n')
          {
             unsigned char h;
             unsigned char l;

             h = fromHexNibble(pszReturnData[i]);
             i++;
             if(pszReturnData[i]=='\0') continue;
             l = fromHexNibble(pszReturnData[i]);
             i++;

             if(h >= 16 || l >= 16) continue;

             /*
              * FIXME: The array tchar[] was used uninitialized.
              * It's not clear to me the original purpose of the
              * piece of code using it. To be removed in future
              * versions.
              */

             tchar[0]=tchar[1];
             tchar[1]=tchar[2];
             tchar[2]=tchar[3];
             tchar[3] = (h << 4) + l;
             tchar[4]='\0';

             if (strncmp(tchar, "tcp:", 4) == 0)
             {
               local_buf[in-7]='1';
               local_buf[in-6]=strlen(port)+47;

               in++;
               local_buf[in]=pszReturnData[i-2];
               in++;
               local_buf[in]=pszReturnData[i-1];

               strcat(local_buf,"6c6f63616c686f73743a");
               in+=20;

               chport=&port[0];

               while(*chport!='\0')
               {
                 in++;
                 local_buf[in]=hex[(*chport >> 4) & 0xf];
                 in++;
                 local_buf[in]=hex[*chport & 0xf];
                 *chport++;
               }

               strcat(local_buf,"00");
               in+=2;

               while(pszReturnData[i]!='\n')
               {
                 i++;
               }
             }
             else
             {
               in++;
               local_buf[in]=pszReturnData[i-2];
               in++;
               local_buf[in]=pszReturnData[i-1];
             }
           }

           in++;
           local_buf[in]=pszReturnData[i];
        }

        in++;
      }

      local_buf[in]=0;

      if (strlen(local_buf))
      {
        extern int ChangeWindowProperty(WindowPtr pWin, Atom property, Atom type,
                                        int format, int mode, unsigned long len,
                                        pointer value, Bool sendevent);

        mcop_local_atom = MakeAtom(mcop_atom, strlen(mcop_atom), 1);
        ChangeWindowProperty(WindowTable[pScreen->myNum],
                             mcop_local_atom,
                             XA_STRING,
                             iReturnFormat, PropModeReplace,
                             strlen(local_buf), local_buf, 1);
      }

      xfree(local_buf);
    }
  }
}

#endif

#ifdef NXAGENT_RECONNECT 

Bool nxagentReopenScreen(int index, ScreenPtr pScreen, int argc, char** argv)
{
  unsigned long valuemask;
  XSetWindowAttributes attributes;
  XSizeHints sizeHints;

  /*
   * FIXME: It's to be better investigated if we should
   * assume nxagentDoFullGeneration here.
   */

  if (nxagentDoFullGeneration || 1 /* FIXME */)
  {
    nxagentEventMask |= FocusChangeMask;
    valuemask = CWBackPixel | CWEventMask | CWColormap | (nxagentOption(Fullscreen)?CWOverrideRedirect:0);
    attributes.background_pixel = nxagentBlackPixel;
    attributes.event_mask = nxagentEventMask;
    attributes.colormap = nxagentDefaultVisualColormap(nxagentDefaultVisual(pScreen));

    #ifdef NXAGENT_FULLSCREEN

    if(nxagentOption(Fullscreen))
    {
      attributes.override_redirect = True;

      nxagentChangeOption(X, 0);
      nxagentChangeOption(Y, 0);
      nxagentChangeOption(Width,  WidthOfScreen(DefaultScreenOfDisplay(nxagentDisplay)));
      nxagentChangeOption(Height, HeightOfScreen(DefaultScreenOfDisplay(nxagentDisplay)));
      nxagentChangeOption(BorderWidth, 0);

      /*
       * We need to disable the host's screensaver or
       * it will otherwise grab the screen even if it
       * is under agent's control.
       */

      XSetScreenSaver(nxagentDisplay, 0, 0, DefaultExposures, DefaultBlanking);
    }

    #endif

    if (nxagentParentWindow != 0)
    {
      nxagentDefaultWindows[pScreen->myNum] = nxagentParentWindow;

      XSelectInput (nxagentDisplay, nxagentDefaultWindows[pScreen->myNum],
                      nxagentEventMask);
    }
    else
    {
      #ifdef TEST
      fprintf(stderr, "nxagentReopenScreen: Going to create new default window.\n");
      #endif

      nxagentDefaultWindows[pScreen->myNum] =
          XCreateWindow(nxagentDisplay,
                        DefaultRootWindow(nxagentDisplay),
                        nxagentOption(X) + POSITION_OFFSET,
                        nxagentOption(Y) + POSITION_OFFSET,
                        nxagentOption(Width),
                        nxagentOption(Height),
                        nxagentOption(BorderWidth),
                        pScreen->rootDepth,
                        InputOutput,
                        nxagentDefaultVisual(pScreen),
                        valuemask, &attributes);

      #ifdef TEST
      fprintf(stderr, "nxagentReopenScreen: Created new default window with id [%ld].\n",
                  nxagentDefaultWindows[pScreen->myNum]);
      #endif

        /*
         * FIXME: This whole part has been rewritten and moved to Atom.c
         *        Reopening the screen must be treated as a sub-case of
         *        the normal procedure.
         */

        XInternAtoms(nxagentDisplay, nxagentAtomNames, NXAGENT_NUMBER_OF_ATOMS, FALSE, nxagentAtoms);

        /* FIXME:
           nxagentAtoms[0] = "NX_IDENTITY"
           nxagentAtoms[1] = "WM_PROTOCOL"
           We are supposing that NX_IDENTITY has been created by us.
           So we are testing wether WM_PROTOCOL has been created now
           and so its number is bigger than that of NX_IDENTITY or
           is lesser and somebody else has created it.
           That's a hack to check wether there was a Window manager
           running on the X server. Because as we always create
           the WM_PROTOCOLS atom this can fool ourselves and we will
           think that there was a WM and activate the magic pixel
           minimization. To avoid this problem we test the order
           of creation of the atoms and disable the WM_PROTCOLS
           if it seems was created after our private atom NX_IDENTITY.
        */
        if( nxagentAtoms[1] > nxagentAtoms[0] )
        {
            nxagentAtoms[1] = None;
        }

        /* nxagentAtoms[9] - NXDARWIN atom */
        if (nxagentAtoms[9] > nxagentAtoms[1])
        {
          nxagentAtoms[9] = None;
        }

        {
            Atom IdentityAtom;

            int Type[4] = { 1, 0, 85, 0 };

            IdentityAtom = nxagentAtoms[0];  /* NX_IDENTITY */

            XChangeProperty(nxagentDisplay,
                            nxagentDefaultWindows[pScreen->myNum],
                            IdentityAtom,
                            XA_ATOM,
                            sizeof(int)*8,
                            PropModeReplace,
                            (unsigned char*)&Type,
                            4
                           );
        }

#ifdef NXAGENT_FULLSCREEN
        if(nxagentOption(Fullscreen)){
            nxagentFullscreenWindow = nxagentDefaultWindows[pScreen->myNum];
        }

        if(nxagentIpaq)
        {
            XWindowChanges ch;
            unsigned int ch_mask;
            ch.stack_mode = Below;
            ch_mask = CWStackMode;
            XConfigureWindow(nxagentDisplay, nxagentFullscreenWindow, ch_mask, &ch);
        }
#endif
    }

#ifdef NXAGENT_FULLSCREEN

    if (nxagentOption(Fullscreen))
    {
      XChangeProperty(nxagentDisplay,
                      nxagentDefaultWindows[pScreen->myNum], 
                      nxagentAtoms[8], /* NX_AGENT_SIGNATURE */
                      XA_STRING,
                      8, 
                      PropModeReplace, 
                      (unsigned char*)"X-AGENT",
                      strlen("X-AGENT"));
 
        nxagentEventMask |= (EnterWindowMask | LeaveWindowMask);
        nxagentEventMask |= KeyPressMask | KeyReleaseMask | ButtonPressMask | ButtonReleaseMask;
        XSelectInput (nxagentDisplay, nxagentFullscreenWindow,
                      nxagentEventMask);
    }
#endif

#ifdef NXAGENT_REPARENT_DEBUG
    fprintf(stderr, "root window ID: %X\n",
            nxagentDefaultWindows[pScreen->myNum]);
#endif

#ifdef NXAGENT_REPARENT
    /* we want to know where the pointer is */
    XSelectInput (nxagentDisplay, DefaultRootWindow(nxagentDisplay),
                  PointerMotionMask | KeyPressMask | KeyReleaseMask | KeymapStateMask);
/*                   ButtonPressMask | ButtonReleaseMask | PointerMotionMask ); */
/*                   KeyPressMask | KeyReleaseMask | KeymapStateMask); */

/*                   PointerMotionMask); */
#endif

    sizeHints.flags = PPosition | PMinSize | PMaxSize;
    sizeHints.x = nxagentOption(X) + POSITION_OFFSET;
    sizeHints.y = nxagentOption(Y) + POSITION_OFFSET;
    sizeHints.width = sizeHints.max_width = sizeHints.min_width = nxagentOption(Width);
    sizeHints.height = sizeHints.max_height = sizeHints.min_height = nxagentOption(Height);
    if (nxagentUserGeometry & XValue || nxagentUserGeometry & YValue)
      sizeHints.flags |= USPosition;
    if (nxagentUserGeometry & WidthValue || nxagentUserGeometry & HeightValue)
      sizeHints.flags |= USSize;

    XSetStandardProperties(nxagentDisplay,
                           nxagentDefaultWindows[pScreen->myNum],
                           nxagentWindowName,
                           nxagentWindowName,
                           nxagentIconPixmap,
                           argv, argc, &sizeHints);

    if (1)
    {
      XWMHints wmHints;
      wmHints.icon_pixmap = nxagentIconPixmap;
      if (useXpmIcon)
      {
        wmHints.icon_mask = nxagentIconShape;
        wmHints.flags = IconPixmapHint | IconMaskHint;
      }
      else
      {
        wmHints.flags = IconPixmapHint;
      }
      XSetWMHints (nxagentDisplay, nxagentDefaultWindows[pScreen->myNum], &wmHints);
    }

    XClearWindow(nxagentDisplay, nxagentDefaultWindows[pScreen->myNum]);
    XMapWindow(nxagentDisplay, nxagentDefaultWindows[pScreen->myNum]);

#ifdef NXAGENT_FULLSCREEN

    if(nxagentOption(Fullscreen))
    {
        valuemask = CWBackPixmap | CWColormap | CWOverrideRedirect;
    }
    else
    {
        valuemask = CWBackPixmap | CWColormap;
    }

#else

    valuemask = CWBackPixmap | CWColormap;

#endif

    attributes.background_pixmap = nxagentScreenSaverPixmap;
    attributes.colormap =
      DefaultColormap(nxagentDisplay, DefaultScreen(nxagentDisplay));

#ifdef NXAGENT_FULLSCREEN

    if(nxagentOption(Fullscreen)){
        XSetInputFocus(nxagentDisplay, nxagentFullscreenWindow,
                       RevertToParent, CurrentTime);
        attributes.override_redirect = False;
        XGrabKeyboard(nxagentDisplay, nxagentFullscreenWindow, True, GrabModeAsync,
                      GrabModeAsync, CurrentTime);
    }

#endif

#ifdef NXAGENT_FULLSCREEN

    if (nxagentOption(Fullscreen))
    {
      attributes.override_redirect = False;

      valuemask |= CWOverrideRedirect;

      #ifdef TEST
      fprintf(stderr, "nxagentReopenScreen: Going to create new icon window.\n");
      #endif

      nxagentIconWindow =
          XCreateWindow(nxagentDisplay,
                        DefaultRootWindow(nxagentDisplay),
                        0, 0, 1, 1, 0,
                        DefaultDepth(nxagentDisplay, DefaultScreen(nxagentDisplay)),
                        InputOutput,
                        DefaultVisual(nxagentDisplay, DefaultScreen(nxagentDisplay)),
                        valuemask, &attributes);

      #ifdef TEST
      fprintf(stderr, "nxagentReopenScreen: Created new icon window with id [%ld].\n",
                  nxagentIconWindow);
      #endif
    }

#endif

#ifndef NXAGENT_NEVERSS

    #ifdef TEST
    fprintf(stderr, "nxagentReopenScreen: Going to create new screen saver window.\n");
    #endif

    nxagentScreenSaverWindows[pScreen->myNum] =
        XCreateWindow(nxagentDisplay,
                      nxagentDefaultWindows[pScreen->myNum],
                      0, 0, nxagentOption(Width), nxagentOption(Height), 0,
                      DefaultDepth(nxagentDisplay, DefaultScreen(nxagentDisplay)),
                      InputOutput,
                      DefaultVisual(nxagentDisplay, DefaultScreen(nxagentDisplay)),
                      valuemask, &attributes);

    #ifdef TEST
    fprintf(stderr, "nxagentReopenScreen: Created new screen saver window with id [%ld].\n",
                nxagentScreenSaverWindows[pScreen->myNum]);
    #endif

#endif

#ifdef NXAGENT_FULLSCREEN

    if(nxagentOption(Fullscreen)){
        sizeHints.flags = PMinSize | PMaxSize;
        sizeHints.min_width = sizeHints.max_height = 1;
        sizeHints.min_height = sizeHints.max_height = 1;

        XSetStandardProperties(nxagentDisplay,
                               nxagentIconWindow,
                               nxagentWindowName,
                               nxagentWindowName,
                               nxagentIconPixmap,
                               0, 0, &sizeHints);

        /* Start helper window in iconified state */
        {
            XWMHints wmHints;
            wmHints.flags = IconPixmapHint | IconMaskHint;
            wmHints.initial_state = IconicState;
            wmHints.icon_pixmap = nxagentIconPixmap;
            if (useXpmIcon)
            {
              wmHints.icon_mask = nxagentIconShape;
              wmHints.flags = IconPixmapHint | IconMaskHint;
            }
            else
            {
              wmHints.flags = StateHint | IconPixmapHint;
            }
            XSetWMHints (nxagentDisplay,
                         nxagentIconWindow,
                         &wmHints);

            XSelectInput ( nxagentDisplay,
                           nxagentIconWindow,
                           (nxagentEventMask & ~(KeyPressMask | KeyReleaseMask)) | StructureNotifyMask);
            XGrabKeyboard(nxagentDisplay, nxagentFullscreenWindow,
                          True, GrabModeAsync,
                          GrabModeAsync, CurrentTime);
            XSetInputFocus(nxagentDisplay, nxagentFullscreenWindow,
                           RevertToParent, CurrentTime);

            XGrabKey(nxagentDisplay, AnyKey, AnyModifier, nxagentFullscreenWindow,
                         True, GrabModeAsync, GrabModeAsync);

            if(!nxagentIpaq)
            {
                XMapWindow( nxagentDisplay,
                            nxagentIconWindow);
            }
            else
            {
               XMapWindow( nxagentDisplay, nxagentIconWindow);
               XIconifyWindow (nxagentDisplay, nxagentIconWindow, DefaultScreen(nxagentDisplay));
            }
        }
    }

#endif

  }

  if (!nxagentCreateDefaultColormap(pScreen)) return False;

#ifdef NXAGENT_ONEXIT

  if (nxagent_WM != None)  /* WM_PROTOCOLS */
  {
    Atom deleteWMatom = nxagentAtoms[2];  /* WM_DELETE_WINDOW */

#ifdef NXAGENT_ONEXIT_DEBUG
    fprintf(stderr, "WM atom is [%d]\n",deleteWMatom);
#endif
    XSetWMProtocols(nxagentDisplay, nxagentDefaultWindows[pScreen->myNum], &deleteWMatom,1);
    if (nxagentOption(Fullscreen))
    {
      XSetWMProtocols(nxagentDisplay, nxagentIconWindow, &deleteWMatom,1);
    }
  }

#endif

#ifdef NXAGENT_ONSTART

  nxagent_WM_START = nxagentAtoms[3];  /* WM_NX_READY */

#endif

#ifdef NXAGENT_TIMESTAMP
  {
    extern unsigned long startTime;
    fprintf(stderr, "Screen: open screen finished, time is [%d] milliseconds.\n",
          GetTimeInMillis() - startTime);
  }
#endif

  return True;
}

Bool nxagentReCreateScreen(void*p0)
{
  CARD16 w, h;
  extern Drawable nxagentDefaultDrawables[];
  PixmapPtr pPixmap = (PixmapPtr)nxagentDummyScreen->devPrivate;
  int flexibility;

  flexibility = *(int*)p0;

#if defined(NXAGENT_RECONNECT_DEBUG) || defined(NXAGENT_RECONNECT_SCREEN_DEBUG)
  fprintf(stderr, "nxagentReCreateScreen\n");
#endif

  nxagentReopenScreen(0, nxagentDummyScreen, nxagentArgc, nxagentArgv);

  nxagentPixmap(pPixmap) = XCreatePixmap(nxagentDisplay, 
                                         nxagentDefaultWindows[ nxagentDummyScreen->myNum ],
                                         pPixmap -> drawable.width,
                                         pPixmap -> drawable.height,
                                         pPixmap -> drawable.depth);
#ifdef NXAGENT_RECONNECT_SCREEN_DEBUG
  fprintf(stderr, "nxagentReCreateScreen: recreated %p - ID %lx\n",
                   pPixmap,
                   nxagentPixmap( pPixmap ));
#endif
  w = 16;
  h = 16;
  (* nxagentDummyScreen->QueryBestSize)(StippleShape, &w, &h, nxagentDummyScreen);
  if (!(nxagentPixmap(nxagentDummyScreen->PixmapPerDepth[0]) =
       XCreatePixmap(nxagentDisplay, 
                     nxagentDefaultDrawables[1],
                     w, 
                     h, 
                     1)));

  nxagentEventMask |= NXAGENT_KEYBOARD_EVENT_MASK | NXAGENT_POINTER_EVENT_MASK;
  XSelectInput(nxagentDisplay, nxagentDefaultWindows[0], nxagentEventMask);

  return True;  
}

#endif /* NXAGENT_RECONNECT */
