/**************************************************************************/
/*                                                                        */
/* Copyright (c) 2001,2002 NoMachine, http://www.nomachine.com.           */
/*                                                                        */
/* NXPROXY, NX protocol compression and NX extensions to this software    */
/* are copyright of NoMachine. Redistribution and use of the present      */
/* software is allowed according to terms specified in the file LICENSE   */
/* which comes in the source distribution.                                */
/*                                                                        */
/* Check http://www.nomachine.com/licensing.html for applicability.       */
/*                                                                        */
/* NX and NoMachine are trademarks of Medialogic S.p.A.                   */
/*                                                                        */
/* All rigths reserved.                                                   */
/*                                                                        */
/**************************************************************************/


#include "SessionInterface.h"
#include "StringUtilities.h"
#include "Utilities.h"
#include "NXSettings.h"
#include "NXConnection.h"
#include "NXRunVersion.h"

#include <stdio.h>
#include <iostream>
using namespace std;

#include <unistd.h>
#include <signal.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/wait.h>



NXConnection *pConnection = NULL;


static bool ParseCommandLine( int argc_, char** argv_, string& file_path )
{
  // Very simple...
  if( argc_ == 2 )
  {
    file_path = argv_[1];

    if( file_path != "--help" && file_path != "-h" )
      return true;
  }

  fprintf( stdout, "Usage: %s 'session file path'\n", argv_[0] );
  file_path = "";
  return false;
}

static void GetLogin( NXSettings* sets )
{
  string sPrevGroup = sets->GetGroup();
  sets->SetGroup( "Login" );
  string password = sets->GetString( "Password", "" );
  string username = sets->GetString( "User", "" );

  if( username.empty() )
  {
    cout << "Login: " << flush;
    cin >> username;
    sets->SetString( "User", username );
  }

  if( password.empty() )
  {
    string prompt = username;
    prompt += "'s password: ";
    password = getpass( prompt.c_str() );
    sets->SetString( "Password", NX::Utilities::GenerateMD5( (username + password) ) );
  }
  sets->SetGroup( sPrevGroup );
}

static void SetConnectionError( string error )
{
  if( !error.empty() && error[(error.size()-1)] != '.' )
    error += ".";
  cerr << "Error: " << error << endl << flush;
}

static void SetConnectionMessage( string message )
{
  static string last_message = "";

  if( message != last_message )
  {
    last_message = message;
    if( message[(message.size()-1)] != '.' )
      message += ".";
    cout << "Info: " << message << endl << flush;
  }
}

void Welcome()
{
  string welcome = "NXRUN - version ";
  welcome += NX_RUN_VERSION;
  cout << welcome << endl << flush;
}

static void HandleCloseAll( int my_signal )
{
  if( pConnection != NULL )
  {
    cout << "Info: Closing all running processes..." << endl << flush;
    cout << "Info: Session log is '" << pConnection->GetLogPath() << "'." << endl << flush;
    pConnection->Stop();
    waitpid( -1, NULL, WNOHANG );
  }
  cout << "Info: Shutting down and exit." << endl << flush;
  exit(0);
}

int main( int argc, char** argv )
{
  signal( SIGINT, HandleCloseAll );

  Welcome();

  string NX_ConfigFilePath = "";
  if( !ParseCommandLine( argc, argv, NX_ConfigFilePath ) )
    return 1;

  if( !NX::Utilities::FileExist( NX_ConfigFilePath ) )
  {
    SetConnectionError( NX_ConfigFilePath + " file not found" );
    return 1;
  }

  NXSettings sets;
  sets.SetFilePath( NX_ConfigFilePath );
  if( !sets.Read() )
  {
    string msg = "Parsing error in file ";
    msg += NX_ConfigFilePath;
    SetConnectionError( msg );
    return 1;
  }

  GetLogin( &sets );


  NXConnection nxConnection;
  pConnection = &nxConnection;

  if( !nxConnection.SetParameters( &sets ) )
  {
    SetConnectionError( nxConnection.GetError() );
    return 1;
  }

  nxConnection.Start();
  if( nxConnection.ErrorOccurred() )
  {
    SetConnectionError( nxConnection.GetError() );
    return 1;
  }

  int CheckTimeout = 250;
  bool error_occurred = false;

  for( ;; )
  {
    nxConnection.Advance( CheckTimeout );

    if( nxConnection.ErrorOccurred() )
    {
      SetConnectionError( nxConnection.GetError() );
      error_occurred = true;
      break;
    }

    string sState = nxConnection.GetState();
    if( !sState.empty() )
      SetConnectionMessage( sState );

    if( nxConnection.Accepted() )
      break;

  }

  if( error_occurred )
  {
    string msg = "Error occurred. For more info check '";
    msg += nxConnection.GetLogPath();
    msg += "'";
    SetConnectionMessage( msg );
    return 1;
  }
  else
  {
    SetConnectionMessage( "Session accepted. Please wait for NX window..." );
    return 0;
  }
}


