/*
 * Copyright (c) 2004 Nokia. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the
 * distribution.
 *
 * Neither the name of Nokia nor the names of its contributors may be
 * used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef NetscapePlugin_h
#define NetscapePlugin_h

#include <glib.h>
#include <npapi.h>
#include <npupp.h>

#include "KWIQPlugin.h"

class KWIQBridgeApp;

class NetscapePlugin : public KWIQPlugin
{
 public:
  NetscapePlugin(NPPluginFuncs *funcs);
  ~NetscapePlugin();

  void setWindow(void*);
  void newStream();
  void destroyStream();
  void writeReady();
  void write();
  void print();
  void event();
  void urlNotify();

  /** null terminated list of embed -tag parameters (name,value pairs). lists are copied */  
  void setParams(gchar** namev, gchar** valuev);

  void setSavedData(NPSavedData *data);
  void setMimeType(const gchar* type);
  const gchar* mimeType() const;
  
  void create(KWIQBridgeApp* bridge);
  NPSavedData* destroy();
  
 private:
  
  NPPluginFuncs *pluginFuncs;
  NPP npp;
  gchar **argn, **argv;
  int argc;
  NPSavedData *sdata;
  gchar *m_mimeType;
  NPWindow window;
  NPSetWindowCallbackStruct ws_info;
  void clearParams();

};

#endif
