#define WNCK_I_KNOW_THIS_IS_UNSTABLE

/* This file is largely copied from the libwnck example code */

#include "config.h"

#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>

#include <libwnck/libwnck.h>
#include <gtk/gtk.h>
#include <libxml/tree.h>

#include "global.h"

#include "options.h"
#include "choices.h"

char *app_dir = NULL;

static GdkWindow *socket = NULL;	/* NULL => Not an applet */

static WnckScreen *screen = NULL;

static GtkWidget *pager = NULL;

static Option n_rows;

/* Read the contents of this property. g_free() the result. */
static char *read_property(GdkWindow *window, GdkAtom prop,
			   GdkAtom type, gint *out_length)
{
	gint	grab_len = 4096;
	gint	length;
	guchar	*data;

	while (1)
	{
		if (!(gdk_property_get(window, prop, type, 0, grab_len,
				FALSE, NULL, NULL, &length, &data) && data))
			return NULL;	/* Error? */

		if (length >= grab_len)
		{
			/* Didn't get all of it - try again */
			grab_len <<= 1;
			g_free(data);
			continue;
		}

		*out_length = length;

		return data;
	}
}

static char *read_string(GdkWindow *window, GdkAtom prop)
{
	gint  len;
	gchar *data;

	data = read_property(window, prop,
			gdk_atom_intern("STRING", FALSE), &len);
	
	if (!data)
		return NULL;

	data = g_realloc(data, len + 1);
	data[len] = '\0';
	return data;
}

static void position(GtkMenu *menu, gint *x, gint *y, gboolean *push_in,
		     gpointer user_data)
{
	GtkRequisition req;
	int  margin = 2;
	int screen_width, screen_height;
	char *pos = (char *) user_data;
	char *comma;

	*push_in = TRUE;

	gdk_window_get_pointer(NULL, x, y, NULL);

	screen_width = gdk_screen_width();
	screen_height = gdk_screen_height();

	if (pos)
	{
		comma = strchr(pos, ',');
		if (comma)
			margin = atoi(comma + 1);
	}

	gtk_widget_size_request(GTK_WIDGET(menu), &req);

	if (!pos)
	{
		*x -= req.width / 2;
		*y -= 32;
		goto out;
	}
	
	if (pos[0] == 'T')
	{
		*y = margin;
		*x -= req.width / 4;
	}
	else if (pos[0] == 'B')
	{
		*y = screen_height - margin - req.height;
		*x -= req.width / 4;
	}
	else if (pos[0] == 'L')
	{
		*x = margin;
		*y -= 16;
	}
	else
	{
		*x = screen_width - margin - req.width;
		*y -= 16;
	}

	g_free(pos);

out:
	*x = CLAMP(*x, 4, screen_width - 4 - req.width);
	*y = CLAMP(*y, 4, screen_height - 4 - req.height);
}

static void show_help(void)
{
	char *argv[3] = {"rox", NULL, NULL};
	GError *error = NULL;

	argv[1] = g_build_filename(getenv("APP_DIR"), "Help", NULL);
	g_spawn_async(NULL, argv, NULL, G_SPAWN_SEARCH_PATH,
			NULL, NULL, NULL, &error);
	g_free(argv[1]);

	if (error)
	{
		GtkWidget *box;
		box = gtk_message_dialog_new(NULL, 0, GTK_MESSAGE_ERROR,
					GTK_BUTTONS_OK, "%s", error->message);
		gtk_dialog_run(GTK_DIALOG(box));
		gtk_widget_destroy(box);
		g_error_free(error);
	}
}

static GList *get_window_list(void)
{		
	GList *window_list = NULL;
	GList *l = wnck_screen_get_windows_stacked(screen);	
	while (l)
	{
		WnckWindow *window = WNCK_WINDOW(l->data);
		if (!(wnck_window_is_skip_pager(window) ||
		      wnck_window_is_skip_tasklist(window)))
			window_list = g_list_append(window_list, l->data);
		l = l->next;
	}
	g_list_free(l);
	return window_list;
}

static gboolean button_event(GtkWidget *widget,
			     GdkEventButton *event,
			     gpointer user_data)
{
	if (event->button == 3)
	{
		GtkWidget *menu;
		GtkWidget *item;
		GList	*wins;
		gchar   *pos = NULL;

		if (socket)
		{
			pos = read_string(socket,
				gdk_atom_intern("_ROX_PANEL_MENU_POS",
						FALSE));
		}

		
		wins = get_window_list();	
		menu = wnck_create_window_menu(wins);
		
		item = gtk_menu_item_new();
		gtk_menu_append(GTK_MENU(menu), item);
		gtk_widget_show(item);

		item = gtk_menu_item_new_with_label(_("Help"));
		gtk_signal_connect(GTK_OBJECT(item), "activate",
				GTK_SIGNAL_FUNC(show_help), NULL);
		gtk_menu_append(GTK_MENU(menu), item);
		gtk_widget_show(item);

		item = gtk_menu_item_new_with_label(_("Options"));
		gtk_signal_connect(GTK_OBJECT(item), "activate",
				GTK_SIGNAL_FUNC(options_show), NULL);
		gtk_menu_append(GTK_MENU(menu), item);
		gtk_widget_show(item);

		item = gtk_menu_item_new_with_label(_("Quit"));
		gtk_signal_connect(GTK_OBJECT(item), "activate",
				GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
		gtk_menu_append(GTK_MENU(menu), item);
		gtk_widget_show(item);

		gtk_menu_popup(GTK_MENU(menu), NULL, NULL,
				position, pos,
				event->button, event->time);
		return 1;
	}

	return 0;
}

typedef enum {
	ORIENT_UNREAD,
	ORIENT_HORIZ,
	ORIENT_VERT,
	ORIENT_UNKNOWN
} Orient;

static Orient panel_get_orient(void)
{
	static Orient panel_orient = ORIENT_UNREAD;

	if (panel_orient == ORIENT_UNREAD)
	{
		char *pos;

		panel_orient = ORIENT_UNKNOWN;

		if (socket)
		{
			pos = read_string(socket,
				gdk_atom_intern("_ROX_PANEL_MENU_POS", FALSE));

			if (pos[0] == 'T' || pos[0] == 'B')
				panel_orient = ORIENT_HORIZ;
			else if (pos[0] == 'L' || pos[0] == 'R')
				panel_orient = ORIENT_VERT;
			g_free(pos);
		}

	}
	return panel_orient;
}

static void work_out_size(int alloc_width, int alloc_height,
		int *width, int *height)
{
	double aspect;
	Orient orient = panel_get_orient();
	int n_screens = wnck_screen_get_workspace_count(
				wnck_screen_get_default());

	*width = alloc_width;
	*height = alloc_height;
	if (orient == ORIENT_UNKNOWN)
		return;
	/* Been occasionally getting 0 here for some reason */
	g_return_if_fail(n_screens > 0);

	/* FIXME: Aspect ratio always looks slightly wrong to me (TH) so we
	 * probably need to take borders and workspace dividers into account or
	 * something
	 */
	if (orient == ORIENT_HORIZ)
	{
		aspect = ((double) gdk_screen_width() /
			  (double) gdk_screen_height() * (double) n_screens) /
			 (double) n_rows.int_value / (double) n_rows.int_value;
		*height = alloc_height;
		*width = (int) ((double) *height * aspect);
	}
	else
	{
		aspect = ((double) gdk_screen_height() /
			  (double) gdk_screen_width() * (double) n_screens) /
			 (double) n_rows.int_value / (double) n_rows.int_value;
		*width = alloc_width;
		*height = (int) ((double) *width * aspect);
	}
}

static void set_size_request(GtkWidget *widget, int alloc_width, int
		alloc_height, gboolean force)
{
	int width, height;
	Orient orient;

	/* If not in a panel do nothing */
	if (!socket)
		return;

	orient = panel_get_orient();
	/* Earlier experiments appeared to show that widget should actually be
	 * 4 pixels smaller than its allocation.
	if (orient == ORIENT_VERT)
		alloc_width -= 4;
	else
		alloc_height -= 4;
	 */
	/* Don't do anything if the size change appears to be a result of the
	 * above "feature" 
	 */
	work_out_size(alloc_width, alloc_height, &width, &height);

	/* We're only using the panel's height as a guide for setting the
	 * widget's width (vice versa for vertical panels) and must stick to 8
	 * for our height allocation */
	if (orient == ORIENT_VERT)
	{
		if (height == alloc_height)
			return;
		width = 8;
	}
	else
	{
		if (width == alloc_width)
			return;
		height = 8;
	}
	gtk_widget_set_size_request(widget, width, height);
}

static void resize_handler(GtkWidget *widget, GtkAllocation *allocation,
        gpointer data)
{
	set_size_request(widget, allocation->width, allocation->height, FALSE);
	(void) data;
}

static void options_changed(void)
{
	if (n_rows.has_changed)
	{
		wnck_pager_set_n_rows(WNCK_PAGER(pager), n_rows.int_value);
		set_size_request(pager, pager->allocation.width,
				pager->allocation.height, TRUE);
	}
}

static void set_trans(void)
{
	struct stat info;
	guchar	*path;
	gchar	*lang2 = NULL;
	const char *lang;

	gtk_set_locale();

	rox_clear_translation();

	lang = getenv("LANG");
	if (!lang)
		return;
	/* Extract the language code from the locale name.
	 * language[_territory][.codeset][@modifier]
	 */
	if (lang[0] != '\0' && lang[1] != '\0'
	    && (lang[2] == '_' || lang[2] == '.' || lang[2] == '@'))
		lang2 = g_strndup((gchar *) lang, 2);

	path = g_strdup_printf("%s/Messages/%s.gmo", app_dir,
			lang2 ? lang2 : lang);
	g_free(lang2);

	if (stat(path, &info) == 0)
		rox_add_translations(path);
	g_free(path);
}

int main(int argc, char **argv)
{
	GtkWidget  *toplevel, *frame;

	app_dir = g_strdup(getenv("APP_DIR"));
	if (!app_dir)
		g_error("APP_DIR environment variable was unset!\n"
			"Use the AppRun script to invoke " PROJECT "...\n");

	gtk_init(&argc, &argv);

	set_trans();

	choices_init();
	options_init();
	option_add_int(&n_rows, "n_rows", 2);

	option_add_notify(options_changed);

	/* Send errors to stdout. Prevents bugs in OpenOffice flooding the
	 * error stream.
	 */
	dup2(1, 2);

	screen = wnck_screen_get_default();

	/* because the pager doesn't respond to signals at the moment */
	wnck_screen_force_update(screen);

	if (argc == 2)
	{
		gint32 xid;

		xid = atol(argv[1]);
		toplevel = gtk_plug_new(xid);
		/*gtk_widget_set_size_request(toplevel, 100, 20);*/
		socket = gdk_window_foreign_new(xid);
	}
	else
	{
		GdkPixbuf *pixbuf;
		gchar *file;

		toplevel = gtk_window_new(GTK_WINDOW_TOPLEVEL);
		gtk_window_stick(GTK_WINDOW(toplevel));
		gtk_window_set_title(GTK_WINDOW(toplevel), "Pager");

		file = g_build_filename(app_dir, ".DirIcon", NULL);
		pixbuf = gdk_pixbuf_new_from_file(file, NULL);
		if (pixbuf)
		{
			gtk_window_set_icon(GTK_WINDOW(toplevel), pixbuf);
			gdk_pixbuf_unref(pixbuf);
		}
		g_free(file);
	}

	g_signal_connect(toplevel, "destroy",
			 G_CALLBACK(gtk_main_quit), NULL);

	frame = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_IN);
	gtk_container_add(GTK_CONTAINER(toplevel), frame);  
	
	pager = wnck_pager_new(screen);
	wnck_pager_set_n_rows(WNCK_PAGER(pager), n_rows.int_value);
	if (panel_get_orient() == ORIENT_VERT)
		wnck_pager_set_orientation(WNCK_PAGER(pager),
					GTK_ORIENTATION_VERTICAL);

	gtk_container_add(GTK_CONTAINER(frame), pager);

	g_signal_connect(pager, "button-press-event",
			G_CALLBACK(button_event), NULL);
	if (argc == 2)
	{
		gtk_widget_set_size_request(pager, 8, 8);
		g_signal_connect(pager, "size-allocate",
				G_CALLBACK(resize_handler), NULL);
	}

	gtk_widget_show_all(toplevel);

	gtk_main();

	return 0;
}
