#include <qwidget.h>
#include <qpointarray.h>
#include <qregion.h>
#include <qpixmap.h>


class QVFb;
class QVFbView;


class Skin : public QWidget
{
    Q_OBJECT
public:
    Skin( QVFb *p, const QString &skinFile, int &viewW, int &viewH );
    ~Skin( );
    void setView( QVFbView *v );
    void setZoom( double );
    bool isValid() {return skinValid;}

protected slots:
    void skinKeyRepeat();

protected:
    virtual void paintEvent( QPaintEvent * );
    virtual void mousePressEvent( QMouseEvent *e );
    virtual void mouseMoveEvent( QMouseEvent *e );
    virtual void mouseReleaseEvent( QMouseEvent * );
private:
    QVFb *parent;
    QVFbView *view;
    QPoint clickPos;
    bool buttonPressed;
    int buttonIndex;
    bool skinValid;
    double zoom;
    void calcRegions();

    void loadImages();
    QString skinImageUpFileName;
    QString skinImageDownFileName;
    QPixmap skinImageUp;
    QPixmap skinImageDown;
    int viewX1, viewY1;
    int numberOfAreas;

    typedef struct {
	QString	name;
        int	keyCode;
        QPointArray area;
        QRegion region;
	QString text;
    } ButtonAreas;

    void startPress(int);
    void endPress();

    ButtonAreas *areas;
    int joystick;
    bool joydown;
    QTimer *t_skinkey;
    int onjoyrelease;
};


