/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the designer application of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef KEYSEQUENCEEDITOR_H
#define KEYSEQUENCEEDITOR_H

#include "propertyeditor_global.h"

#include <QHBoxWidget>
#include <QKeySequence>

class QLineEdit;
class QToolButton;

class QT_PROPERTYEDITOR_EXPORT KeySequenceEditor: public QHBoxWidget
{
    Q_OBJECT
public:
    KeySequenceEditor(QWidget *parent = 0);
    virtual ~KeySequenceEditor();

    QKeySequence keySequence() const;
    
    QToolButton *resetButton() const;
    QLineEdit *lineEdit() const;

    virtual bool eventFilter(QObject *o, QEvent *e);

signals:
    void changed();
    
public slots:
    void setKeySequence(const QKeySequence &keySequence);
    void reset();

protected:
    void handleKeyEvent(QKeyEvent *e);
    int translateModifiers(Qt::ButtonState state);

private:
    QLineEdit *m_lineEdit;
    QToolButton *m_resetButton;
    bool mouseEnter;
    int num;
    int k1, k2, k3, k4;
};

#endif // KEYSEQUENCEEDITOR_H
