/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the designer application of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "orderindicator.h"
#include "formwindow.h"

#include <qpainter.h>
#include <qbitmap.h>
#include <qapplication.h>
#include <qevent.h>

OrderIndicator::OrderIndicator(int i, QWidget* w, FormWindow *fw)
    : QWidget(fw, Qt::WMouseNoMask), formWindow(fw)
{
    setObjectName("order_indicator");
    order = -1;
    m_widget = w;
    setAttribute(Qt::WA_NoBackground);
    setAutoMask(true);
    setOrder(i, w);
}


OrderIndicator::~OrderIndicator()
{
}


void OrderIndicator::setOrder(int i, QWidget* wid)
{
    if (m_widget != wid)
        return;
    if (!wid->isVisibleTo(formWindow)) {
        hide();
        return;
    }

    if (order == i) {
        show();
        raise();
        return;
    }
    order = i;
    int w = fontMetrics().width(QString::number(i)) + 10;
    int h = fontMetrics().lineSpacing() * 3 / 2;
    QFont f(font());
    f.setBold(true);
    setFont(f);
    resize(qMax(w, h), h);
    update(); // in case the size didn't change
    reposition();
    show();
    raise();
}

void OrderIndicator::reposition()
{
    QPoint p =parentWidget()->mapFromGlobal(m_widget->mapToGlobal(m_widget->rect().topLeft()));
    move(p - QPoint(width()/3, height()/3));
}


void OrderIndicator::paintEvent(QPaintEvent *)
{
    QPainter p(this);
    p.setPen(Qt::white);
    p.setBrush(Qt::blue);
    p.drawEllipse(rect());
    p.drawText(rect(), Qt::AlignCenter, QString::number(order));
}


void OrderIndicator::updateMask()
{
    QBitmap bm(size());
    bm.fill(Qt::color0);
    {
        QPainter p(&bm);
        p.setPen(Qt::color1);
        p.setBrush(Qt::color1);
        p.drawEllipse(rect());
    }
    setMask(bm);
}

void OrderIndicator::mousePressEvent(QMouseEvent *e)
{
    QApplication::sendEvent(m_widget, e);
}
