/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the designer application of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "qlayoutwidget_propertysheet.h"
#include "qdesigner_widget.h"
#include "formwindow.h"
#include "formeditor.h"

#include <qextensionmanager.h>

#include <QLayout>
#include <QMetaObject>
#include <QMetaProperty>
#include <qdebug.h>

QLayoutWidgetPropertySheet::QLayoutWidgetPropertySheet(QLayoutWidget *object, QObject *parent)
    : QDesignerPropertySheet(object, parent)
{
    m_fakeProperties.clear();
    
    for (int index = 0; index < count(); ++index) {
        QString pname = propertyName(index);
        setVisible(index, false);
        if (pname == QLatin1String("margin")
                || pname == QLatin1String("spacing")
                /*|| pname == QLatin1String("objectName") ### */ )
            setVisible(index, true);
    }
}

QLayoutWidgetPropertySheet::~QLayoutWidgetPropertySheet()
{
}

void QLayoutWidgetPropertySheet::setProperty(int index, const QVariant &value)
{    
    QDesignerPropertySheet::setProperty(index, value);
    
    QLayoutWidget *l = static_cast<QLayoutWidget*>(m_object);
    AbstractFormEditor *core = l->formWindow()->core();
    if (IPropertySheet *sheet = qt_extension<IPropertySheet*>(core->extensionManager(), l->layout())) {
        sheet->setChanged(sheet->indexOf(propertyName(index)), true);
    }
}


QLayoutWidgetPropertySheetFactory::QLayoutWidgetPropertySheetFactory(QExtensionManager *parent)
    : DefaultExtensionFactory(parent)
{
}

QObject *QLayoutWidgetPropertySheetFactory::createExtension(QObject *object, const QString &iid, QObject *parent) const
{
    if (iid != Q_TYPEID(IPropertySheet))
        return 0;

    if (QLayoutWidget *o = qt_cast<QLayoutWidget*>(object))
        return new QLayoutWidgetPropertySheet(o, parent);

    return 0;
}
