/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the designer application of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef WIDGETDATABASE_H
#define WIDGETDATABASE_H

#include "formeditor_global.h"

#include <abstractformeditor.h>
#include <abstractwidgetdatabase.h>

#include <QString>
#include <QIcon>

class QObject;

struct WidgetDataBaseItem: public AbstractWidgetDataBaseItem
{
    WidgetDataBaseItem(const QString &name = QString::null,
                       const QString &group = QString::null);

    QString name() const;
    void setName(const QString &name);

    QString group() const;
    void setGroup(const QString &group);

    QString toolTip() const;
    void setToolTip(const QString &toolTip);

    QString whatsThis() const;
    void setWhatsThis(const QString &whatsThis);

    QString includeFile() const;
    void setIncludeFile(const QString &includeFile);

    QIcon icon() const;
    void setIcon(const QIcon &icon);

    bool isCompat() const;
    void setCompat(bool compat);
    
    bool isContainer() const;
    void setContainer(bool b);

    bool isForm() const;
    void setForm(bool b);

    bool isCustom() const;
    void setCustom(bool b);

private:
    QString m_name;
    QString m_group;
    QString m_toolTip;
    QString m_whatsThis;
    QString m_includeFile;
    QIcon m_icon;
    uint m_compat: 1;
    uint m_container: 1;
    uint m_form: 1;
    uint m_custom: 1;
};

class QT_FORMEDITOR_EXPORT WidgetDataBase: public AbstractWidgetDataBase
{
    Q_OBJECT
public:
    WidgetDataBase(AbstractFormEditor *core, QObject *parent = 0);
    virtual ~WidgetDataBase();
    
    virtual AbstractFormEditor *core() const;    
    
    virtual AbstractWidgetDataBaseItem *item(int index) const;
    int indexOfObject(QObject *o, bool resolveName = true) const;
    
public slots:
    void loadPlugins();

private:
    AbstractFormEditor *m_core;
};

#endif // WIDGETDATABASE_H
