/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the demonstration applications of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "alphashade.h"
#include "clipping.h"
#include "demoviewer.h"
#include "introscreen.h"
#include "paths.h"
#include "roads.h"
#include "rotatinggradient.h"
#include "warpix.h"
#ifndef QT_NO_OPENGL
#include <qgl.h>
#include "glpainter.h"
#endif
#include "textoutline.h"
#include "mandelbrotwidget.h"
#include "items.h"

#include <qapplication.h>

int main(int argc, char **argv)
{
    QApplication app(argc, argv);

    DemoViewer viewer;
    viewer.addDemoWidget("Arthur - The Paint Engine", new IntroScreen, "introscreen.cpp");
    viewer.addDemoWidget("Alphablended primitives", new AlphaShade, "alphashade.cpp");
    viewer.addDemoWidget("Rotating Gradient", new RotatingGradient, "rotatinggradient.cpp");
    viewer.addDemoWidget("Clip Regions", new Clipping, "clipping.cpp");
    viewer.addDemoWidget("Paths", new Paths, "paths.cpp");
    viewer.addDemoWidget("On the road", new Roads, "roads.cpp");
    viewer.addDemoWidget("Stretched Pixmap", new Warpix, "warpix.cpp");
    viewer.addDemoWidget("Threaded Mandelbrot", new MandelbrotWidget, "mandelbrotwidget.cpp");
    viewer.addDemoWidget("Items", new Items, "items.cpp");
#if !(defined(QT_NO_XFT) && defined(Q_WS_X11))
    viewer.addDemoWidget("Outline", new TextOutline, "textoutline.cpp");
#endif
#ifndef QT_NO_OPENGL
    if (QGLFormat::hasOpenGL())
	viewer.addDemoWidget("OpenGL Painter", new GLPainter, "glpainter.cpp");
#endif
    viewer.show();

    QObject::connect(&app, SIGNAL(lastWindowClosed()), &app, SLOT(quit()));
    return app.exec();
}
