/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the demonstration applications of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef DEMOVIEWER_H
#define DEMOVIEWER_H

#include <qhash.h>
#include <qwidget.h>

class Attributes;
class DemoWidget;
class QCheckBox;
class QComboBox;
class QListWidget;
class QPushButton;
class QStackedWidget;
class QTextEdit;

class DemoViewer : public QWidget
{
    Q_OBJECT
public:
    DemoViewer(QWidget *parent = 0);

    void addDemoWidget(const QString &name, DemoWidget *demoWidget, const QString &file);

    QSize sizeHint() const;

    void showEvent(QShowEvent *event);
    void hideEvent(QHideEvent *event);

public slots:
    void itemSelected();
    void antialiasChanged(bool);
    void alphaChanged(bool);
    void fillModeChanged(int);
    void openSource(bool);

private:
    QListWidget *listWidget;
    QStackedWidget *widgets;
    QHash<QString, DemoWidget *> widgetByName;
    QHash<QString, QString> fileByName;
    Attributes *attributes;
    QTextEdit *sourceViewer;
    QPushButton *viewSourceButton;

    QCheckBox *antialias;
    QCheckBox *alpha;
    QComboBox *bgMode;
};

#endif
