/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the demonstration applications of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef MANDELBROTWIDGET_H
#define MANDELBROTWIDGET_H

#include "demowidget.h"
#include "renderthread.h"

#include <qwidget.h>
#include <qpixmap.h>

class MandelbrotWidget : public DemoWidget
{
    Q_OBJECT
public:
    MandelbrotWidget(QWidget *parent = 0);

    QSize sizeHint() const;

    enum Zoom { ZoomIn, ZoomOut };
    void zoom(Zoom z);

    void startAnimation() { resetState(); }
    void stopAnimation() {}

public slots:
    void drawRenderedImage(const QImage &image);

protected:
    void paintEvent(QPaintEvent *);
    void mousePressEvent(QMouseEvent *event);
    void mouseMoveEvent(QMouseEvent *event);
    void mouseReleaseEvent(QMouseEvent *event);
    void wheelEvent(QWheelEvent *event);
    void resizeEvent(QResizeEvent *);
    void keyPressEvent(QKeyEvent *event);

    double cx;
    double cy;
    double scale;
    double lastScale;

    QPoint moveAnchor;

    QPoint pixmapDrawPoint;

    QPixmap pixmap;

    RenderThread renderThread;
};

#endif
