/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the core module of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QREADWRITELOCK_H
#define QREADWRITELOCK_H

#include <qglobal.h>
#include <limits.h>

struct QReadWriteLockPrivate;

class Q_CORE_EXPORT QReadWriteLock
{
public:
     enum AccessMode {
        ReadAccess = 0,
        WriteAccess
    };

    explicit QReadWriteLock(const int maxReaders=INT_MAX);
    ~QReadWriteLock();

    void lock(AccessMode mode);
    bool tryLock(AccessMode mode);
    void unlock();
private:
    Q_DISABLE_COPY(QReadWriteLock)

    QReadWriteLockPrivate * d;
};

class Q_CORE_EXPORT QReadWriteLockLocker
{
public:
    inline QReadWriteLockLocker(QReadWriteLock *readWriteLock,
                                QReadWriteLock::AccessMode accessMode)
        : lock(readWriteLock), access(accessMode)
    { relock(); }
    inline ~QReadWriteLockLocker()
    { unlock(); }

    inline void unlock()
    { if (lock) lock->unlock(); }

    inline void relock()
    { if (lock) lock->lock(access); }

private:
    Q_DISABLE_COPY(QReadWriteLockLocker)

    QReadWriteLock *lock;
    QReadWriteLock::AccessMode access;
};

#endif
