/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the gui module of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QWHATSTHIS_H
#define QWHATSTHIS_H

#include "qobject.h"
#include "qcursor.h"
#include "qaction.h"

#ifndef QT_NO_WHATSTHIS

#ifdef QT_COMPAT
class QToolButton;
#endif

class Q_GUI_EXPORT QWhatsThis
{
    QWhatsThis();
public:
    static void enterWhatsThisMode();
    static bool inWhatsThisMode();
    static void leaveWhatsThisMode();

    static void showText(const QPoint &pos, const QString& text, QWidget* w = 0);
    static void hideText();

#ifdef QT_COMPAT
    static QT_COMPAT void add(QWidget *w, const QString &s);
    static QT_COMPAT void remove(QWidget *);
    static QT_COMPAT QToolButton * whatsThisButton(QWidget * parent);
#endif
};

class QWhatsThisAction: public QAction
{
    Q_OBJECT

public:
    QWhatsThisAction(QObject* parent = 0);

private slots:
    void actionTriggered();
};

#endif // QT_NO_WHATSTHIS

#endif // QWHATSTHIS_H
