/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the tools applications of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef WRITEINITIALIZATION_H
#define WRITEINITIALIZATION_H

#include "treewalker.h"

#include <qpair.h>
#include <qhash.h>
#include <qstack.h>
#include <qtextstream.h>

class Driver;
class Uic;
struct Option;

struct WriteInitialization : public TreeWalker
{
    WriteInitialization(Uic *uic);

//
// widgets
//
    void acceptUI(DomUI *node);
    void acceptWidget(DomWidget *node);
    void acceptLayout(DomLayout *node);
    void acceptSpacer(DomSpacer *node);
    void acceptLayoutItem(DomLayoutItem *node);

//
// actions
//
    void acceptActionGroup(DomActionGroup *node);
    void acceptAction(DomAction *node);
    void acceptActionRef(DomActionRef *node);

//
// tab stops
//
    void acceptTabStops(DomTabStops *tabStops);

//
// custom widgets
//
    void acceptCustomWidgets(DomCustomWidgets *node);
    void acceptCustomWidget(DomCustomWidget *node);

//
// layout defaults
//
    void acceptLayoutDefault(DomLayoutDefault *node);

//
// signal/slot connections
//    
    void acceptConnection(DomConnection *connection);

private:
    static QString domColor2QString(DomColor *c);

    QString pixCall(DomResourcePixmap *pix) const;
    QString trCall(const QString &str, const QString &className) const;
    QString trCall(const DomString *str, const QString &className) const;

    void writeProperties(const QString &varName, const QString &className,
                         const QList<DomProperty*> &lst);
    void writeColorGroup(DomColorGroup *colorGroup, const QString &group, const QString &paletteName);

    QString translate(const QString &text, const QString &className=QString::null) const;

//
// special initialization
//
    void initializeMenu(DomWidget *w, const QString &parentWidget);
    void initializeListBox(DomWidget *w);
    void initializeIconView(DomWidget *w);
    void initializeListView(DomWidget *w);
    void initializeListViewItems(const QString &className, const QString &varName, const QList<DomItem*> &items);
    void initializeTable(DomWidget *w);
    void initializeTableItems(const QString &className, const QString &varName, const QList<DomItem*> &items);

//
// Sql
//
    void initializeSqlDataTable(DomWidget *w);
    void initializeSqlDataBrowser(DomWidget *w);
    
private:
    Uic *uic;
    Driver *driver;
    QTextStream &output;
    const Option &option;
    bool m_stdsetdef;

    struct Buddy
    {
        Buddy(const QString &oN, const QString &b)
            : objName(oN), buddy(b) {}
        QString objName;
        QString buddy;
    };

    QStack<DomWidget*> m_widgetChain;
    QStack<DomLayout*> m_layoutChain;
    QStack<DomActionGroup*> m_actionGroupChain;
    QList<Buddy> m_buddies;

    QHash<QString, QString> m_buttonGroups;
    QHash<QString, DomWidget*> m_registeredWidgets;
    int m_defaultMargin;
    int m_defaultSpacing;

    QString m_generatedClass;

    QString m_delayedInitialization;
    QTextStream refreshOut;

    QString m_delayedActionInitialization;
    QTextStream actionOut;
};


#endif // WRITEINITIALIZATION_H
