/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the tools applications of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "widgetinfo.h"

#include <QtGui/QtGui>
#include <Qt3Compat/Qt3Compat>

WidgetInfo::WidgetInfo()
{
}

const QMetaObject *WidgetInfo::metaObject(const QString &widgetName)
{
    if (widgetName == QLatin1String("QObject"))
        return &QObject::staticMetaObject;
    else if (widgetName == QLatin1String("QToolBar"))
        return &QToolBar::staticMetaObject;
    else if (widgetName == QLatin1String("Q3ToolBar"))
        return &Q3ToolBar::staticMetaObject;
    else if (widgetName == QLatin1String("QPushButton"))
        return &QPushButton::staticMetaObject;
    else if (widgetName == QLatin1String("QToolButton"))
        return &QToolButton::staticMetaObject;
    else if (widgetName == QLatin1String("QCheckBox"))
        return &QCheckBox::staticMetaObject;
    else if (widgetName == QLatin1String("QRadioButton"))
        return &QRadioButton::staticMetaObject;
    else if (widgetName == QLatin1String("QGroupBox"))
        return &Q3GroupBox::staticMetaObject;
    else if (widgetName == QLatin1String("QButtonGroup"))
        return &Q3ButtonGroup::staticMetaObject;
    else if (widgetName == QLatin1String("QDateEdit"))
        return &Q3DateEdit::staticMetaObject;
    else if (widgetName == QLatin1String("QTimeEdit"))
        return &Q3TimeEdit::staticMetaObject;
    else if (widgetName == QLatin1String("QDateTimeEdit"))
        return &Q3DateTimeEdit::staticMetaObject;
    else if (widgetName == QLatin1String("QListBox")
             || widgetName == QLatin1String("Q3ListBox"))
        return &Q3ListBox::staticMetaObject;
    else if (widgetName == QLatin1String("QListView") ||
             widgetName == QLatin1String("Q3ListView"))
        return &Q3ListView::staticMetaObject;
    else if (widgetName == QLatin1String("QLineEdit"))
        return &QLineEdit::staticMetaObject;
    else if (widgetName == QLatin1String("QSpinBox"))
        return &QSpinBox::staticMetaObject;
    else if (widgetName == QLatin1String("QSplitter"))
        return &QSplitter::staticMetaObject;
    else if (widgetName == QLatin1String("QTextEdit"))
        return &Q3TextEdit::staticMetaObject;
    else if (widgetName == QLatin1String("QLabel"))
        return &QLabel::staticMetaObject;
    else if (widgetName == QLatin1String("QTabWidget"))
        return &QTabWidget::staticMetaObject;
    else if (widgetName == QLatin1String("QWidgetStack"))
        return &Q3WidgetStack::staticMetaObject;
    else if (widgetName == QLatin1String("QComboBox"))
        return &QComboBox::staticMetaObject;
    else if (widgetName == QLatin1String("QWidget"))
        return &QWidget::staticMetaObject;
    else if (widgetName == QLatin1String("QDialog"))
        return &QDialog::staticMetaObject;
    else if (widgetName == QLatin1String("QWizard"))
        return &Q3Wizard::staticMetaObject;
    else if (widgetName == QLatin1String("QLCDNumber"))
        return &QLCDNumber::staticMetaObject;
    else if (widgetName == QLatin1String("QProgressBar"))
        return &QProgressBar::staticMetaObject;
    else if (widgetName == QLatin1String("QTextView")
             || widgetName == QLatin1String("Q3TextView"))
        return &Q3TextView::staticMetaObject;
    else if (widgetName == QLatin1String("QTextBrowser"))
        return &QTextBrowser::staticMetaObject;
    else if (widgetName == QLatin1String("QDial"))
        return &QDial::staticMetaObject;
    else if (widgetName == QLatin1String("QSlider"))
        return &QSlider::staticMetaObject;
    else if (widgetName == QLatin1String("QScrollBar"))
        return &QScrollBar::staticMetaObject;
    else if (widgetName == QLatin1String("QFrame"))
        return &QFrame::staticMetaObject;
    else if (widgetName == QLatin1String("QMainWindow"))
        return &QMainWindow::staticMetaObject;
    else if (widgetName == QLatin1String("Q3MainWindow"))
        return &Q3MainWindow::staticMetaObject;
    else if (widgetName == QLatin1String("QToolBox"))
        return &QToolBox::staticMetaObject;
    else if (widgetName == QLatin1String("Line"))
        return &QFrame::staticMetaObject;
    else if (widgetName == QLatin1String("TextLabel"))
        return &QLabel::staticMetaObject;
    else if (widgetName == QLatin1String("PixmapLabel"))
        return &QLabel::staticMetaObject;
    else if (widgetName == QLatin1String("QActionGroup"))
        return &QActionGroup::staticMetaObject;
    else if (widgetName == QLatin1String("QAction"))
        return &QAction::staticMetaObject;

    return 0;
}

bool WidgetInfo::isValidProperty(const QString &className, const QString &name)
{
    const QMetaObject *meta = metaObject(className);
    if (!meta)
        return true;

    return meta->indexOfProperty(name) != -1;
}

bool WidgetInfo::isValidSignal(const QString &className, const QString &name)
{
    const QMetaObject *meta = metaObject(className);
    if (!meta)
        return true;

    return meta->indexOfSignal(name) != -1;
}

bool WidgetInfo::isValidSlot(const QString &className, const QString &name)
{
    const QMetaObject *meta = metaObject(className);
    if (!meta)
        return true;

    return meta->indexOfSlot(name) != -1;
}

bool WidgetInfo::isValidEnumerator(const QString &className, const QString &name)
{
    const QMetaObject *meta = metaObject(className);
    if (!meta)
        return true;

    return checkEnumerator(meta, name);
}

bool WidgetInfo::checkEnumerator(const QMetaObject *meta, const QString &name)
{
    for (int i=0; i<meta->enumeratorCount(); ++i)
        if (checkEnumerator(meta->enumerator(i), name))
            return true;
    return false;
}

bool WidgetInfo::checkEnumerator(const QMetaEnum &metaEnum, const QString &name)
{
    return metaEnum.keyToValue(name) != -1;
}


QString WidgetInfo::resolveEnumerator(const QString &className, const QString &name)
{
    const QMetaObject *meta = metaObject(className);
    if (!meta) {
        QString e = resolveEnumerator(QLatin1String("QObject"), QLatin1String("Qt::") + name);
        if (e.size())
            return e;

        return QLatin1String(name);
    }

    return resolveEnumerator(meta, name);
}

QString WidgetInfo::resolveEnumerator(const QMetaObject *meta, const QString &name)
{
    for (int i=0; i<meta->enumeratorCount(); ++i) {
        QString e = resolveEnumerator(meta->enumerator(i), name);
        if (e.size())
            return e;
    }

    return QString::null;
}

QString WidgetInfo::resolveEnumerator(const QMetaEnum &metaEnum, const QString &name)
{
    QString scope = QLatin1String(metaEnum.scope());

    int idx = metaEnum.keyToValue(name);
    if (idx != -1) {
        QString enumerator = name;
        int i = enumerator.indexOf(QLatin1String("::"));
        if (i != -1)
            enumerator = enumerator.mid(i + 2);

        return scope + QLatin1String("::") + enumerator;
    }

    return QString::null;
}

