/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the designer application of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef LAYOUT_H
#define LAYOUT_H

#include "formeditor_global.h"

#include <layoutinfo.h>

#include <QWidget>
#include <QMap>
#include <QPointer>
#include <QObject>
#include <QLayout>
#include <QGridLayout>
#include <QMap>

class FormWindow;

void add_to_box_layout(QBoxLayout *box, QWidget *widget);
void insert_into_box_layout(QBoxLayout *box, int index, QWidget *widget);
void add_to_grid_layout(QGridLayout *grid, QWidget *widget, int r, int c, int rs, int cs, Qt::Alignment align = Qt::AlignAuto);

class Layout : public QObject
{
    Q_OBJECT
public:
    Layout(const QList<QWidget*> &wl, QWidget *p, FormWindow *fw, QWidget *lb, bool splitter = false);
    virtual ~Layout();

    virtual void setup();

    virtual void doLayout() = 0;
    virtual void undoLayout();
    virtual void breakLayout();
    virtual bool prepareLayout(bool &needMove, bool &needReparent);
    virtual void finishLayout(bool needMove, QLayout *layout);

protected:
    QList<QWidget*> widgets;
    QWidget *m_parentWidget;
    QPoint startPoint;
    QMap<QPointer<QWidget>, QRect> geometries;
    QWidget *layoutBase;
    FormWindow *formWindow;
    QRect oldGeometry;
    bool isBreak;
    bool useSplitter;


protected slots:
    void widgetDestroyed();

};

class HorizontalLayout : public Layout
{
public:
    HorizontalLayout(const QList<QWidget*> &wl, QWidget *p, FormWindow *fw, QWidget *lb, bool splitter = false);

    void doLayout();

protected:
    void setup();

};

class VerticalLayout : public Layout
{
public:
    VerticalLayout(const QList<QWidget*> &wl, QWidget *p, FormWindow *fw, QWidget *lb, bool splitter = false);

    void doLayout();

protected:
    void setup();

};

class StackedLayout : public Layout
{
public:
    StackedLayout(const QList<QWidget*> &wl, QWidget *p, FormWindow *fw, QWidget *lb, bool splitter = false);

    void doLayout();

protected:
    void setup();

};


class Grid;

class GridLayout : public Layout
{
public:
    GridLayout(const QList<QWidget*> &wl, QWidget *p, FormWindow *fw, QWidget *lb, const QSize &res);
    ~GridLayout();

    void doLayout();

protected:
    void setup();
    QWidget *widgetAt(QGridLayout *layout, int row, int column) const;

protected:
    void buildGrid();
    QSize resolution;
    Grid* grid;

};

class VerticalLayoutList: public QList<QWidget*>
{
public:
    VerticalLayoutList(const QList<QWidget*> &l)
        : QList<QWidget*>(l) {}

    static bool lessThan(const QWidget *a, const QWidget *b)
    {  return a->y() < b->y(); }

    void sort()
    { qSort(*this, lessThan); }
};

class HorizontalLayoutList : public QList<QWidget*>
{
public:
    HorizontalLayoutList(const QList<QWidget*> &l)
        : QList<QWidget*>(l) {}

    static bool hLessThan(const QWidget *a, const QWidget *b)
    { return a->x() < b->x(); }

    void sort()
    { qSort(*this, hLessThan); }
};

namespace Utils // ### fix the namespace
{

inline int indexOfWidget(QLayout *layout, QWidget *widget)
{
    int index = 0;
    while (QLayoutItem *item = layout->itemAt(index)) {
        if (item->widget() == widget)
            return index;

        ++index;
    }

    return -1;
}

} // namespace Utils

#endif // LAYOUT_H
