/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the designer application of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef PROPERTYEDITOR_H
#define PROPERTYEDITOR_H

#include "propertyeditor_global.h"

#include <abstractformeditor.h>
#include <abstractpropertyeditor.h>

#include <qpropertyeditor.h>
#include <QPointer>

class DomProperty;

class QT_PROPERTYEDITOR_EXPORT PropertyEditor: public AbstractPropertyEditor
{
    Q_OBJECT
public:
    PropertyEditor(AbstractFormEditor *core, QWidget *parent, Qt::WFlags flags = 0);
    virtual ~PropertyEditor();

    virtual AbstractFormEditor *core() const;

    virtual bool isReadOnly() const;
    virtual void setReadOnly(bool readOnly);
    virtual void setPropertyValue(const QString &name, const QVariant &value);
    virtual void setObject(QObject *object);

    virtual QObject *object() const
    { return m_object; }

private slots:
    void firePropertyChanged(IProperty *property);

private:
    IProperty *propertyByName(IProperty *p, const QString &name);
    void clearDirty(IProperty *p);

    void createPropertySheet(PropertyCollection *root, QObject *object);

    static IProperty *createSpecialProperty(const QVariant &value,
            const QString &name);

private:
    AbstractFormEditor *m_core;
    QPropertyEditor::View *m_editor;
    IPropertyGroup *m_properties;
    QPointer<QObject> m_object;
};

#endif // PROPERTYEDITOR_H
