/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the designer application of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef DEFAULTSPECIALEDITOR_H
#define DEFAULTSPECIALEDITOR_H

#include "specialeditor.h"
#include "default_extensionfactory.h"
#include <QObject>

class QDialog;
class QLineEdit;
class QWidget;
class QAbstactButton;
struct IPropertySheet;

class QDesignerSpecialEditor : public QObject, public ISpecialEditor
{
    Q_OBJECT
    Q_INTERFACES(ISpecialEditor)
public:
    QDesignerSpecialEditor(QWidget *theWidget, IPropertySheet *properties, QObject *parent);
    ~QDesignerSpecialEditor();

    QWidget *createEditor(QWidget *parent);

public slots:
    void applyChanges();
    void revertChanges();

private:
    QWidget *mWidget;
    QDialog *mDialog;
    QLineEdit *mLe;
    IPropertySheet *mProperties;
};

class ButtonLineEdit;
class QAbstractButton;

class QButtonSpecialEditor : public QObject, public ISpecialEditor
{
    Q_OBJECT
    Q_INTERFACES(ISpecialEditor)
public:
    QButtonSpecialEditor(QAbstractButton *theButton, IPropertySheet *properties, QObject *parent);
    ~QButtonSpecialEditor();

    QWidget *createEditor(QWidget *parent);

public slots:
    void applyChanges();
    void revertChanges();

private:
    QAbstractButton *mButton;
    ButtonLineEdit *mLe;
    QString mOriginalText;
    IPropertySheet *mProperties;
};

class QDesignerSpecialEditorFactory : public DefaultExtensionFactory
{
    Q_OBJECT
    Q_INTERFACES(ExtensionFactory)
public:
    QDesignerSpecialEditorFactory(QExtensionManager *parent = 0);

protected:
    virtual QObject *createExtension(QObject *object, const QString &iid, QObject *parent) const;
};

#endif // DEFAULTSPECIALEDITOR_H
