/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the designer application of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "abstractformwindow.h"

#include <QMainWindow>

AbstractFormWindow::AbstractFormWindow(QWidget *parent, Qt::WFlags flags)
    : QWidget(parent, flags)
{
}

AbstractFormWindow::~AbstractFormWindow()
{
}

AbstractFormEditor *AbstractFormWindow::core() const
{
    return 0;
}

// This is very similar to the static FormWindow::findFormWindow(), please KEEP IN SYNC.
AbstractFormWindow *AbstractFormWindow::findFormWindow(QWidget *w)
{
    while (w) {
        if (AbstractFormWindow *fw = qt_cast<AbstractFormWindow*>(w)) {
            return fw;
        } else if (qt_cast<QMainWindow*>(w)) {
            /* skip */
        } else if (w->isTopLevel())
            break;
            
        w = w->parentWidget();
    }
    
    return 0;
}
