/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the porting application of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef FILEPORTER_H
#define FILEPORTER_H

#include "rulesfromxml.h"
#include "replacetoken.h"
#include "filewriter.h"
#include <QString>
#include <QMap>

class FilePorter
{
public:
    enum FileType {Header, Source};
    FilePorter(QString rulesFileName);
    void port(QString inBasePath, QString inFilePath, QString outBasePath, QString outFilePath, FileType fileType );
private:
    QByteArray noPreprocess(const QString &fileName);
    QByteArray includeAnalyse(QByteArray file, FileType fileType);

    RulesFromXml rulesFromXml;
    QList<TokenReplacement*> tokenReplacementRules;
    ReplaceToken replaceToken;
    QMap<QString, int> qt4HeaderNames;
};

#endif
