// wxActivateEvent
EVT_ACTIVATE(func)  Process a wxEVT_ACTIVATE event.  
EVT_ACTIVATE_APP(func)  Process a wxEVT_ACTIVATE_APP event.  

// wxCalculateLayoutEvent
EVT_CALCULATE_LAYOUT(func)  Process a wxEVT_CALCULATE_LAYOUT event, which asks the window to take a 'bite' out of a rectangle provided by the algorithm.  

// wxCloseEvent
EVT_CLOSE(func)  Process a close event, supplying the member function. This event applies to wxFrame and wxDialog classes.  
EVT_QUERY_END_SESSION(func)  Process a query end session event, supplying the member function. This event applies to wxApp only.  
EVT_END_SESSION(func)  Process an end session event, supplying the member function. This event applies to wxApp only.  


// wxCommandEvent
EVT_COMMAND(id, event, func)  Process a command, supplying the window identifier, command event identifier, and member function.  
EVT_COMMAND_RANGE(id1, id2, event, func)  Process a command for a range of window identifiers, supplying the minimum and maximum window identifiers, command event identifier, and member function.  
EVT_BUTTON(id, func)  Process a wxEVT_COMMAND_BUTTON_CLICKED command, which is generated by a wxButton control.  
EVT_CHECKBOX(id, func)  Process a wxEVT_COMMAND_CHECKBOX_CLICKED command, which is generated by a wxCheckBox control.  
EVT_CHOICE(id, func)  Process a wxEVT_COMMAND_CHOICE_SELECTED command, which is generated by a wxChoice control.  
EVT_LISTBOX(id, func)  Process a wxEVT_COMMAND_LISTBOX_SELECTED command, which is generated by a wxListBox control.  
EVT_LISTBOX_DCLICK(id, func)  Process a wxEVT_COMMAND_LISTBOX_DOUBLECLICKED command, which is generated by a wxListBox control.  
EVT_TEXT(id, func)  Process a wxEVT_COMMAND_TEXT_UPDATED command, which is generated by a wxTextCtrl control.  
EVT_TEXT_ENTER(id, func)  Process a wxEVT_COMMAND_TEXT_ENTER command, which is generated by a wxTextCtrl control. Note that you must use wxTE_PROCESS_ENTER flag when creating the control if you want it to generate such events.  
EVT_MENU(id, func)  Process a wxEVT_COMMAND_MENU_SELECTED command, which is generated by a menu item.  
EVT_MENU_RANGE(id1, id2, func)  Process a wxEVT_COMMAND_MENU_RANGE command, which is generated by a range of menu items.  
EVT_SLIDER(id, func)  Process a wxEVT_COMMAND_SLIDER_UPDATED command, which is generated by a wxSlider control.  
EVT_RADIOBOX(id, func)  Process a wxEVT_COMMAND_RADIOBOX_SELECTED command, which is generated by a wxRadioBox control.  
EVT_RADIOBUTTON(id, func)  Process a wxEVT_COMMAND_RADIOBUTTON_SELECTED command, which is generated by a wxRadioButton control.  
EVT_SCROLLBAR(id, func)  Process a wxEVT_COMMAND_SCROLLBAR_UPDATED command, which is generated by a wxScrollBar control. This is provided for compatibility only; more specific scrollbar event macros should be used instead (see wxScrollEvent).  
EVT_COMBOBOX(id, func)  Process a wxEVT_COMMAND_COMBOBOX_SELECTED command, which is generated by a wxComboBox control.  
EVT_TOOL(id, func)  Process a wxEVT_COMMAND_TOOL_CLICKED event (a synonym for wxEVT_COMMAND_MENU_SELECTED). Pass the id of the tool.  
EVT_TOOL_RANGE(id1, id2, func)  Process a wxEVT_COMMAND_TOOL_CLICKED event for a range id identifiers. Pass the ids of the tools.  
EVT_TOOL_RCLICKED(id, func)  Process a wxEVT_COMMAND_TOOL_RCLICKED event. Pass the id of the tool.  
EVT_TOOL_RCLICKED_RANGE(id1, id2, func)  Process a wxEVT_COMMAND_TOOL_RCLICKED event for a range of ids. Pass the ids of the tools.  
EVT_TOOL_ENTER(id, func)  Process a wxEVT_COMMAND_TOOL_ENTER event. Pass the id of the toolbar itself. The value of wxCommandEvent::GetSelection is the tool id, or -1 if the mouse cursor has moved off a tool.  
EVT_COMMAND_LEFT_CLICK(id, func)  Process a wxEVT_COMMAND_LEFT_CLICK command, which is generated by a control (Windows 95 and NT only).  
EVT_COMMAND_LEFT_DCLICK(id, func)  Process a wxEVT_COMMAND_LEFT_DCLICK command, which is generated by a control (Windows 95 and NT only).  
EVT_COMMAND_RIGHT_CLICK(id, func)  Process a wxEVT_COMMAND_RIGHT_CLICK command, which is generated by a control (Windows 95 and NT only).  
EVT_COMMAND_SET_FOCUS(id, func)  Process a wxEVT_COMMAND_SET_FOCUS command, which is generated by a control (Windows 95 and NT only).  
EVT_COMMAND_KILL_FOCUS(id, func)  Process a wxEVT_COMMAND_KILL_FOCUS command, which is generated by a control (Windows 95 and NT only).  
EVT_COMMAND_ENTER(id, func)  Process a wxEVT_COMMAND_ENTER command, which is generated by a control.  

// wxDropFilesEvent
EVT_DROP_FILES(func)  Process a wxEVT_DROP_FILES event.  

// wxEraseEvent
EVT_ERASE_BACKGROUND(func)  Process a wxEVT_ERASE_BACKGROUND event.  

// wxFocusEvent
EVT_SET_FOCUS(func)  Process a wxEVT_SET_FOCUS event.  
EVT_KILL_FOCUS(func)  Process a wxEVT_KILL_FOCUS event.  


// wxKeyEvent
EVT_CHAR(func)  Process a wxEVT_CHAR event (a non-modifier key has been pressed).  
EVT_KEY_DOWN(func)  Process a wxEVT_KEY_DOWN event (any key has been pressed).  
EVT_KEY_UP(func)  Process a wxEVT_KEY_UP event (any key has been released).  
EVT_CHAR(func)  Process a wxEVT_CHAR event.  
EVT_CHAR_HOOK(func)  Process a wxEVT_CHAR_HOOK event.  

// wxIdleEvent
EVT_IDLE(func)  Process a wxEVT_IDLE event.  

// wxInitDialogEvent
EVT_INIT_DIALOG(func)  Process a wxEVT_INIT_DIALOG event.  

// wxJoystickEvent
EVT_JOY_BUTTON_DOWN(func)  Process a wxEVT_JOY_BUTTON_DOWN event.  
EVT_JOY_BUTTON_UP(func)  Process a wxEVT_JOY_BUTTON_UP event.  
EVT_JOY_MOVE(func)  Process a wxEVT_JOY_MOVE event.  
EVT_JOY_ZMOVE(func)  Process a wxEVT_JOY_ZMOVE event.  

// wxListEvent
EVT_LIST_BEGIN_DRAG(id, func)  Begin dragging with the left mouse button.  
EVT_LIST_BEGIN_RDRAG(id, func)  Begin dragging with the right mouse button.  
EVT_LIST_BEGIN_LABEL_EDIT(id, func)  Begin editing a label. This can be prevented by calling Veto().  
EVT_LIST_END_LABEL_EDIT(id, func)  Finish editing a label. This can be prevented by calling Veto().  
EVT_LIST_DELETE_ITEM(id, func)  Delete an item.  
EVT_LIST_DELETE_ALL_ITEMS(id, func)  Delete all items.  
EVT_LIST_GET_INFO(id, func)  Request information from the application, usually the item text.  
EVT_LIST_SET_INFO(id, func)  Information is being supplied (not implemented).  
EVT_LIST_ITEM_SELECTED(id, func)  The item has been selected.  
EVT_LIST_ITEM_DESELECTED(id, func)  The item has been deselected.  
EVT_LIST_ITEM_ACTIVATED(id, func)  The item has been activated (ENTER or double click).  
EVT_LIST_KEY_DOWN(id, func)  A key has been pressed.  
EVT_LIST_INSERT_ITEM(id, func)  An item has been inserted.  
EVT_LIST_COL_CLICK(id, func)  A column (m_col) has been left-clicked.  

// wxMenuEvent
EVT_MENU_CHAR(func)  Process a wxEVT_MENU_CHAR event (a keypress when a menu is showing). Windows only; not yet implemented.  
EVT_MENU_INIT(func)  Process a wxEVT_MENU_INIT event (the menu is about to pop up). Windows only; not yet implemented.  
EVT_MENU_HIGHLIGHT(func)  Process a wxEVT_MENU_HIGHLIGHT event (a menu item is being highlighted). Windows only; not yet implemented.  
EVT_POPUP_MENU(func)  Process a wxEVT_POPUP_MENU event (a menu item is being highlighted). Windows only; not yet implemented.  
EVT_CONTEXT_MENU(func)  Process a wxEVT_CONTEXT_MENU event (F1 has been pressed with a particular menu item highlighted). Windows only; not yet implemented.  

// wxMouseEvent
EVT_LEFT_DOWN(func)  Process a wxEVT_LEFT_DOWN event.  
EVT_LEFT_UP(func)  Process a wxEVT_LEFT_UP event.  
EVT_LEFT_DCLICK(func)  Process a wxEVT_LEFT_DCLICK event.  
EVT_MIDDLE_DOWN(func)  Process a wxEVT_MIDDLE_DOWN event.  
EVT_MIDDLE_UP(func)  Process a wxEVT_MIDDLE_UP event.  
EVT_MIDDLE_DCLICK(func)  Process a wxEVT_MIDDLE_DCLICK event.  
EVT_RIGHT_DOWN(func)  Process a wxEVT_RIGHT_DOWN event.  
EVT_RIGHT_UP(func)  Process a wxEVT_RIGHT_UP event.  
EVT_RIGHT_DCLICK(func)  Process a wxEVT_RIGHT_DCLICK event.  
EVT_MOTION(func)  Process a wxEVT_MOTION event.  
EVT_ENTER_WINDOW(func)  Process a wxEVT_ENTER_WINDOW event.  
EVT_LEAVE_WINDOW(func)  Process a wxEVT_LEAVE_WINDOW event.  
EVT_MOUSE_EVENTS(func)  Process all mouse events.  

// wxMoveEvent
EVT_MOVE(func)  Process a wxEVT_MOVE event, which is generated when a window is moved.  

// wxNotebookEvent
EVT_NOTEBOOK_PAGE_CHANGED(id, func)  The page selection was changed. Processes a wxEVT_COMMAND_NOTEBOOK_PAGE_CHANGED event.  
EVT_NOTEBOOK_PAGE_CHANGING(id, func)  The page selection is about to be changed. Processes a wxEVT_COMMAND_NOTEBOOK_PAGE_CHANGING event. This event can be vetoed.  

// EVT_PAINT(func)  Process a wxEVT_PAINT event.  
EVT_PAINT(func)  Process a wxEVT_PAINT event.  

// wxProcessEvent
EVT_END_PROCESS(id, func)  Process a wxEVT_END_PROCESS event. id is the identifier of the process object (the id passed to the wxProcess constructor) or a window to receive the event.  

// wxQueryLayoutInfoEvent
EVT_QUERY_LAYOUT_INFO(func)  Process a wxEVT_QUERY_LAYOUT_INFO event, to get size, orientation and alignment from a window.  

// wxScrollEvent
EVT_SCROLL(func)  Process all scroll events.  
EVT_SCROLL_TOP(func)  Process wxEVT_SCROLL_TOP scroll-to-top events.  
EVT_SCROLL_BOTTOM(func)  Process wxEVT_SCROLL_TOP scroll-to-bottom events.  
EVT_SCROLL_LINEUP(func)  Process wxEVT_SCROLL_LINEUP line up events.  
EVT_SCROLL_LINEDOWN(func)  Process wxEVT_SCROLL_LINEDOWN line down events.  
EVT_SCROLL_PAGEUP(func)  Process wxEVT_SCROLL_PAGEUP page up events.  
EVT_SCROLL_PAGEDOWN(func)  Process wxEVT_SCROLL_PAGEDOWN page down events.  
EVT_SCROLL_THUMBTRACK(func)  Process wxEVT_SCROLL_THUMBTRACK thumbtrack events (frequent events sent as the user drags the thumtrack).  
EVT_SCROLL_THUMBRELEASE(func)  Process wxEVT_SCROLL_THUMBRELEASE thumb release events.  
EVT_COMMAND_SCROLL(id, func)  Process all scroll events.  
EVT_COMMAND_SCROLL_TOP(id, func)  Process wxEVT_SCROLL_TOP scroll-to-top events.  
EVT_COMMAND_SCROLL_BOTTOM(id, func)  Process wxEVT_SCROLL_TOP scroll-to-bottom events.  
EVT_COMMAND_SCROLL_LINEUP(id, func)  Process wxEVT_SCROLL_LINEUP line up events.  
EVT_COMMAND_SCROLL_LINEDOWN(id, func)  Process wxEVT_SCROLL_LINEDOWN line down events.  
EVT_COMMAND_SCROLL_PAGEUP(id, func)  Process wxEVT_SCROLL_PAGEUP page up events.  
EVT_COMMAND_SCROLL_PAGEDOWN(id, func)  Process wxEVT_SCROLL_PAGEDOWN page down events.  
EVT_COMMAND_SCROLL_THUMBTRACK(id, func)  Process wxEVT_SCROLL_THUMBTRACK thumbtrack events (frequent events sent as the user drags the thumtrack).  

// wxScrollWinEvent
EVT_SCROLLWIN(func)  Process all scroll events.  
EVT_SCROLLWIN_TOP(func)  Process wxEVT_SCROLLWIN_TOP scroll-to-top events.  
EVT_SCROLLWIN_BOTTOM(func)  Process wxEVT_SCROLLWIN_TOP scroll-to-bottom events.  
EVT_SCROLLWIN_LINEUP(func)  Process wxEVT_SCROLLWIN_LINEUP line up events.  
EVT_SCROLLWIN_LINEDOWN(func)  Process wxEVT_SCROLLWIN_LINEDOWN line down events.  
EVT_SCROLLWIN_PAGEUP(func)  Process wxEVT_SCROLLWIN_PAGEUP page up events.  
EVT_SCROLLWIN_PAGEDOWN(func)  Process wxEVT_SCROLLWIN_PAGEDOWN page down events.  
EVT_SCROLLWIN_THUMBTRACK(func)  Process wxEVT_SCROLLWIN_THUMBTRACK thumbtrack events (frequent events sent as the user drags the thumtrack).  
EVT_SCROLLWIN_THUMBRELEASE(func)  Process wxEVT_SCROLLWIN_THUMBRELEASE thumb release events.  

// wxSizeEvent
EVT_SIZE(func)  Process a wxEVT_SIZE event.  

// wxSocketEvent
EVT_SOCKET(id, func)  Process a socket event, supplying the member function.  

// wxSysColourChangedEvent
EVT_SYS_COLOUR_CHANGED(func)  Process a wxEVT_SYS_COLOUR_CHANGED event.  

// wxTabEvent
EVT_TAB_SEL_CHANGED(id, func)  Process a wxEVT_TAB_SEL_CHANGED event, indicating that the tab selection has changed.  
EVT_TAB_SEL_CHANGING(id, func)  Process a wxEVT_TAB_SEL_CHANGING event, indicating that the tab selection is changing.  

// wxTreeEvent
EVT_TREE_BEGIN_DRAG(id, func)  Begin dragging with the left mouse button.  
EVT_TREE_BEGIN_RDRAG(id, func)  Begin dragging with the right mouse button.  
EVT_TREE_END_DRAG(id, func)  Drag ended (drop).  
EVT_TREE_BEGIN_LABEL_EDIT(id, func)  Begin editing a label. This can be prevented by calling Veto().  
EVT_TREE_END_LABEL_EDIT(id, func)  Finish editing a label. This can be prevented by calling Veto().  
EVT_TREE_DELETE_ITEM(id, func)  Delete an item.  
EVT_TREE_GET_INFO(id, func)  Request information from the application.  
EVT_TREE_SET_INFO(id, func)  Information is being supplied.  
EVT_TREE_ITEM_EXPANDED(id, func)  Parent has been expanded.  
EVT_TREE_ITEM_EXPANDING(id, func)  Parent is being expanded. This can be prevented by calling Veto().  
EVT_TREE_SEL_CHANGED(id, func)  Selection has changed.  
EVT_TREE_SEL_CHANGING(id, func)  Selection is changing. This can be prevented by calling Veto().  
EVT_TREE_KEY_DOWN(id, func)  A key has been pressed.  

// wxUpdateUIEvent
EVT_UPDATE_UI(id, func)  Process a wxEVT_UPDATE_UI event for the command with the given id.  
EVT_UPDATE_UI_RANGE(id1, id2, func)  Process a wxEVT_UPDATE_UI event for any command with id included in the given range.  

// wxWizardEvent
EVT_WIZARD_PAGE_CHANGED(id, func)  The page has been just changed (this event can not be vetoed).  
EVT_WIZARD_PAGE_CHANGING(id, func)  The page is being changed (this event can be vetoed).  
EVT_WIZARD_CANCEL(id, func)  The user attempted to cancel the wizard (this event may also be vetoed). 
