/*
 *	interface.h - interface to xparts
 *	Copyright (C) 2000 Fred Barnes <frmb2@ukc.ac.uk>
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __INTERFACE_H
#define __INTERFACE_H


/* Structure definitions */

typedef struct __MyXContext {
	int connected;
	Display *display;
	int screen;
	char **argv;
	int argc;
} MyXContext;

typedef struct __Gadget {
	Window window;
	char *name;
	void *pdata;
	GadgetConfigData *config;
	unsigned long fg_pixel;
	unsigned long bg_pixel;
	unsigned long hi_pixel;
	unsigned long sh_pixel;
	Pixmap bg_pixmap;
	int x;
	int y;
	int width;
	int height;
	int visible;
	XFontStruct *fontinfo;
	GC gc;
	void (*expose_event)(XEvent *, struct __Gadget *);
	void (*mousedown_event)(XEvent *, struct __Gadget *);
	void (*mouseup_event)(XEvent *, struct __Gadget *);
	void (*keypress_event)(XEvent *, struct __Gadget *);
	void (*mouseenter_event)(XEvent *, struct __Gadget *);
	void (*mouseleave_event)(XEvent *, struct __Gadget *);
	void (*show_action)(struct __Gadget *);
	void (*hide_action)(struct __Gadget *);
	void (*settext_action)(struct __Gadget *, char *);
	MyXContext *xcxt;
} Gadget;


/* Prototypes for things other than xparts */

#ifndef __INTERFACE_C
	extern MyXContext _xcontext;

	extern int init_xparts (char **in_argv, int in_argc);
	extern int xparts_mainloop (void);
	extern void stop_xparts (void);
	extern void set_error_message (char *);
	extern void set_status_message (char *);
	extern void give_select_function (void (*)(char *));
	extern void give_check_function (void (*)(char *));
	extern void mainloop_terminate (int);
	extern void xparts_readtimeout (int, struct timeval *, void (*)(void), void (*)(void));
	extern void xparts_kill_window (char *window_name);
#endif	/* !__INTERFACE_C */

/* Other prototypes */

#endif	/* !__INTERFACE_H */

