/*****************************************************************************
 * $Id: audio-common.c,v 1.4 2004/09/19 15:55:49 alainjj Exp $
 * Program under GNU General Public License (see ../COPYING)
 *****************************************************************************/

#include <stdio.h>
#include <string.h>
#include "config.h"
#include "audio.h"

#ifdef HAVE_OSS
extern struct AUDRIVER audio_oss;
#endif
#ifdef HAVE_ALSA
extern struct AUDRIVER audio_alsa;
#endif
#ifdef HAVE_SUNAUDIO
extern struct AUDRIVER audio_sun;
#endif
extern struct AUDRIVER audio_dummy;

static struct AUDRIVER *audrivers[] = {
#ifdef HAVE_ALSA
  &audio_alsa,
#endif
#ifdef HAVE_SUNAUDIO
  &audio_sun,
#endif
#ifdef HAVE_OSS
  &audio_oss,
#endif
  &audio_dummy
};

static int audriver=-1;

/* NULL means the default of the driver */
char *audio_dev=NULL;
void audio_init(void) {
  for (audriver = 0;
       audriver < sizeof (audrivers) / sizeof (struct AUDRIVER *); audriver++)
    if(audrivers[audriver] && audrivers[audriver]->check())
      break;
  if(audriver== sizeof (audrivers) / sizeof (struct AUDRIVER *)) {
    fprintf (stderr, "*** NO AUDIO DEVICE FOUND\n");
    audriver=-1;
    return;
  }
  fprintf(stderr, "*** AUDIO DEVICE TYPE = %s\n", audrivers[audriver]->name);
  //audio_open(AUDIO_RW, AUDIO_S16LE, 2, 44100, 48, 2048);
}

int audio_open(int mode, int fmtsample, int nchannels, int freq,
	       int nfrags, int fragsize) {
  if(audriver==-1) return -1;
  return audrivers[audriver]->open(mode,fmtsample,nchannels,freq,nfrags,fragsize);
}

int audio_close(void) {
  if(audriver==-1) return -1;
  return audrivers[audriver]->close();
}

int audio_read(void *r, int n) {
  if(audriver==-1) return -1;
  return audrivers[audriver]->read(r, n);
}

int audio_write(void *w, int n) {
  if(audriver==-1) return -1;
  return audrivers[audriver]->write(w, n);
}

void disable_audio(char *name) {
  int j;
  for(j=0;j<sizeof (audrivers) / sizeof (struct AUDRIVER *);j++)
    if(audrivers[j] && !strcmp(name, audrivers[j]->name))
      audrivers[j] = NULL;
}
