/*****************************************************************************
 * grab.h: interface to the v4l driver functions and definitions
 *****************************************************************************
 * $Id: grab.h,v 1.9 2004/09/25 08:03:47 alainjj Exp $
 *****************************************************************************
 * Copyright (C) 2001 Keuleu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************
 *
 * Original code:
 *
 *   (c) 1997,98 Gerd Knorr <kraxel@cs.tu-berlin.de>
 *
 *****************************************************************************/
#ifndef _GRAB_H_
#define _GRAB_H_

#define TRAP(txt) {fprintf(stderr,"%s:%d:%s\n",__FILE__,__LINE__,txt);exit(1);}

#include "colorspace.h"
extern int debug;
extern int have_dga;

/* ------------------------------------------------------------------------- */

struct device_t {
  char *video;
  char *vbi;
  char *tuner; /* for bktr */
};

struct OVERLAY_CLIP
{
  int x1, x2, y1, y2;
};

struct GRABBER
{
  char *name;
  struct STRTAB *norms;
  struct STRTAB *inputs;

  /* open+close */
  int (*grab_open) (struct device_t *opt);
  int (*grab_close) ();

  /* for overlay */
  int (*grab_overlay) (int x, int y, int width, int height, int format,
               struct OVERLAY_CLIP * oc, int count);

  /* for grabdisplay */
  int (*fmt_available)(video_fmt f);
  void* (*get_img)(video_fmt f, int width, int height);

  /* tunning */
  int (*grab_tune) (unsigned long freq);
  int (*grab_tuned) (void);
  int (*grab_input) (int input, int norm);
  int (*grab_picture) (int color, int bright, int hue, int contrast);
  int (*grab_audio) (int mute, int volume, int *mode);

  /* special uses */
  int (*is525) (int norm);
  int (*issecam) (int norm);
  void* (*get_buf)(int i);
};

/* nb of seconds since 1/1/1970 of the last video frame
   since double have a 52 bits mantissa,
   the stamp has a precision less than 1 microsecond */
extern double videostampmin,videostampmax;

extern int nbufs, nbufs_default, img;
extern struct GRABBER *grabbers[];
extern int grabber;
void grabber_init(void);
extern struct device_t device;
/* the returned images have the endianess of the HOST */
void *get_image(video_fmt f, int width, int height);
int get_image2(void *dest, video_fmt f, int width, int height);
void forcegrabber(char *name);
int get_image2_before_vop(void *dest, video_fmt f, int width, int height);
void *get_image_before_vop(video_fmt f, int width, int height);
extern video_fmt grab_prefered_fmt[MAX_VIDEO_FMT];


#define CAPTURE_OFF          0
#define CAPTURE_OVERLAY      1
#define CAPTURE_GRABDISPLAY  2
#endif // _GRAB_H_
