/*****************************************************************************
 * x11.h: x11 functions and definitions
 *****************************************************************************
 * $Id: x11.h,v 1.8 2004/09/05 06:11:55 alainjj Exp $
 *****************************************************************************
 * Copyright (C) 2001 Keuleu and Maupatz
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *****************************************************************************
 *
 * Original code:
 *
 *  (c) 1998 Gerd Knorr <kraxel@cs.tu-berlin.de>
 *
 *****************************************************************************/
#ifndef _X11_H_
#define _X11_H_

#ifdef HAVE_V4L
#include "videodev.h"
#endif
extern int x11_byteswap, x11_bigendian;
extern int swidth, sheight;
extern int have_xv;
extern int have_video_xv;

void x11_pre_init (void);
void x11_init (void);
XImage *x11_create_ximage (Display * dpy, int width, int height, void **shm);
void x11_destroy_ximage (Display * dpy, XImage * ximage, void *shm);
Pixmap x11_create_pixmap (Widget w, unsigned char *byte_data,
              int width, int height, char *label);

typedef int (*set_overlay) (int x, int y, int w, int h, int f,
                struct OVERLAY_CLIP * oc, int count);

void video_lock_size(void);
void video_unlock_size(void);
void video_set_size (int w, int h);
void video_new_size (void);
void video_overlay (set_overlay);
int (*video_displayframe) (void);

Widget video_init (void);
void video_close (void);
void set_colorkey(Display * dpy, int val);
void video_background(void);
int get_colorkey(Display * dpy);
void video_get_size(int *w, int *h);
unsigned long xv_getfreq(void);
void xv_setfreq(unsigned long freq);
int xv_tuned(void);
void xv_getaudio(int *volume, int *mute);
void xv_setaudio(int volume, int mute);
void xv_setencoding(int encoding);
void xv_setpicture(int color, int bright, int hue, int contrast);
extern Colormap colormap;
extern XVisualInfo *vinfo;
extern Display *dpy;

/* padding of the window */
#define WPAD 16 /* 8 does not work with YUV420 grabbing on some bttv */
#define HPAD 4
#define XPAD 4

/* padding for recording */
#define WRECPAD 32 /* padding for the interface */
#define HRECPAD 16
#define WRECPAD2 8 /* padding for the command line */  
#define HRECPAD2 2
#endif // _X11_H_
