require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_ARM_ATOMIC_H_)) {
    eval 'sub _ARM_ATOMIC_H_ () {1;}' unless defined(&_ARM_ATOMIC_H_);
    if(defined(&_KERNEL)) {
	if(!defined(&CPU_ARMv7)) {
	    require 'arm/cpufunc.ph';
	    require 'arm/armreg.ph';
	    eval 'sub atomic_cas_uint {
	        my($_p, $_o, $_n) = @_;
    		eval q( &_atomic_cas_uint(($_p), ($_o), ($_n)));
	    }' unless defined(&atomic_cas_uint);
	    eval 'sub atomic_cas_ulong {
	        my($_p, $_o, $_n) = @_;
    		eval q( &_atomic_cas_ulong(($_p), ($_o), ($_n)));
	    }' unless defined(&atomic_cas_ulong);
	    eval 'sub atomic_cas_ptr {
	        my($_p, $_o, $_n) = @_;
    		eval q( &_atomic_cas_ptr(($_p), ($_o), ($_n)));
	    }' unless defined(&atomic_cas_ptr);
	    eval 'sub atomic_swap_uint {
	        my($_p, $_n) = @_;
    		eval q( &_atomic_swap_uint(($_p), ($_n)));
	    }' unless defined(&atomic_swap_uint);
	    eval 'sub atomic_swap_ulong {
	        my($_p, $_n) = @_;
    		eval q( &_atomic_swap_ulong(($_p), ($_n)));
	    }' unless defined(&atomic_swap_ulong);
	    eval 'sub atomic_swap_ptr {
	        my($_p, $_n) = @_;
    		eval q( &_atomic_swap_ptr(($_p), ($_n)));
	    }' unless defined(&atomic_swap_ptr);
	    eval 'sub atomic_add_int_nv {
	        my($_p, $_v) = @_;
    		eval q( &_atomic_add_int_nv(($_p), ($_v)));
	    }' unless defined(&atomic_add_int_nv);
	    eval 'sub atomic_add_long_nv {
	        my($_p, $_v) = @_;
    		eval q( &_atomic_add_long_nv(($_p), ($_v)));
	    }' unless defined(&atomic_add_long_nv);
	    eval 'sub atomic_sub_int_nv {
	        my($_p, $_v) = @_;
    		eval q( &_atomic_sub_int_nv(($_p), ($_v)));
	    }' unless defined(&atomic_sub_int_nv);
	    eval 'sub atomic_sub_long_nv {
	        my($_p, $_v) = @_;
    		eval q( &_atomic_sub_long_nv(($_p), ($_v)));
	    }' unless defined(&atomic_sub_long_nv);
	} else {
	    eval 'sub def_atomic_cas {
	        my($_f, $_t) = @_;
    		eval q( &static  &inline $_t $_f( &volatile $_t * &p, $_t  &e, $_t  &n) { $_t  &ret,  &modified;  &__asm  &volatile ( \\"1:	ldrex %0, [%4]		\\\\n\\\\t\\" \\"	cmp %0, %3		\\\\n\\\\t\\" \\"	bne 2f			\\\\n\\\\t\\" \\"	strex %1, %2, [%4]	\\\\n\\\\t\\" \\"	cmp %1, #0		\\\\n\\\\t\\" \\"	bne 1b			\\\\n\\\\t\\" \\"	b 3f			\\\\n\\\\t\\" \\"2:	clrex			\\\\n\\\\t\\" \\"3:				\\\\n\\\\t\\" : \\"=&r\\" ( &ret), \\"=&r\\" ( &modified) : \\"r\\" ( &n), \\"r\\" ( &e), \\"r\\" ( &p) : \\"memory\\", \\"cc\\" );  &return ( &ret); });
	    }' unless defined(&def_atomic_cas);
	    undef(&def_atomic_cas) if defined(&def_atomic_cas);
	    eval 'sub atomic_cas_uint {
	        my($_p, $_e, $_n) = @_;
    		eval q( &_atomic_cas_uint(($_p), ($_e), ($_n)));
	    }' unless defined(&atomic_cas_uint);
	    eval 'sub atomic_cas_ulong {
	        my($_p, $_e, $_n) = @_;
    		eval q( &_atomic_cas_ulong(($_p), ($_e), ($_n)));
	    }' unless defined(&atomic_cas_ulong);
	    eval 'sub atomic_cas_ptr {
	        my($_p, $_e, $_n) = @_;
    		eval q( &_atomic_cas_ptr(($_p), ($_e), ($_n)));
	    }' unless defined(&atomic_cas_ptr);
	    eval 'sub def_atomic_swap {
	        my($_f, $_t) = @_;
    		eval q( &static  &inline $_t $_f( &volatile $_t * &p, $_t  &v) { $_t  &ret,  &modified;  &__asm  &volatile ( \\"1:	ldrex %0, [%3]		\\\\n\\\\t\\" \\"	strex %1, %2, [%3]	\\\\n\\\\t\\" \\"	cmp %1, #0		\\\\n\\\\t\\" \\"	bne 1b			\\\\n\\\\t\\" : \\"=&r\\" ( &ret), \\"=&r\\" ( &modified) : \\"r\\" ( &v), \\"r\\" ( &p) : \\"memory\\", \\"cc\\" );  &return ( &ret); });
	    }' unless defined(&def_atomic_swap);
	    undef(&def_atomic_swap) if defined(&def_atomic_swap);
	    eval 'sub atomic_swap_uint {
	        my($_p, $_v) = @_;
    		eval q( &_atomic_swap_uint(($_p), ($_v)));
	    }' unless defined(&atomic_swap_uint);
	    eval 'sub atomic_swap_ulong {
	        my($_p, $_v) = @_;
    		eval q( &_atomic_swap_ulong(($_p), ($_v)));
	    }' unless defined(&atomic_swap_ulong);
	    eval 'sub atomic_swap_ptr {
	        my($_p, $_v) = @_;
    		eval q( &_atomic_swap_ptr(($_p), ($_v)));
	    }' unless defined(&atomic_swap_ptr);
	    eval 'sub def_atomic_inc_nv {
	        my($_f, $_t) = @_;
    		eval q( &static  &inline $_t $_f( &volatile $_t * &p) { $_t  &ret,  &modified;  &__asm  &volatile ( \\"1:	ldrex %0, [%2]		\\\\n\\\\t\\" \\"	add %0, %0, #1		\\\\n\\\\t\\" \\"	strex %1, %0, [%2]	\\\\n\\\\t\\" \\"	cmp %1, #0		\\\\n\\\\t\\" \\"	bne 1b			\\\\n\\\\t\\" : \\"=&r\\" ( &ret), \\"=&r\\" ( &modified) : \\"r\\" ( &p) : \\"memory\\", \\"cc\\" );  &return ( &ret); });
	    }' unless defined(&def_atomic_inc_nv);
	    undef(&def_atomic_inc_nv) if defined(&def_atomic_inc_nv);
	    eval 'sub atomic_inc_int_nv {
	        my($_p) = @_;
    		eval q( &_atomic_inc_int_nv(($_p)));
	    }' unless defined(&atomic_inc_int_nv);
	    eval 'sub atomic_inc_long_nv {
	        my($_p) = @_;
    		eval q( &_atomic_inc_long_nv(($_p)));
	    }' unless defined(&atomic_inc_long_nv);
	    eval 'sub def_atomic_dec_nv {
	        my($_f, $_t) = @_;
    		eval q( &static  &inline $_t $_f( &volatile $_t * &p) { $_t  &ret,  &modified;  &__asm  &volatile ( \\"1:	ldrex %0, [%2]		\\\\n\\\\t\\" \\"	sub %0, %0, #1		\\\\n\\\\t\\" \\"	strex %1, %0, [%2]	\\\\n\\\\t\\" \\"	cmp %1, #0		\\\\n\\\\t\\" \\"	bne 1b			\\\\n\\\\t\\" : \\"=&r\\" ( &ret), \\"=&r\\" ( &modified) : \\"r\\" ( &p) : \\"memory\\", \\"cc\\" );  &return ( &ret); });
	    }' unless defined(&def_atomic_dec_nv);
	    undef(&def_atomic_dec_nv) if defined(&def_atomic_dec_nv);
	    eval 'sub atomic_dec_int_nv {
	        my($_p) = @_;
    		eval q( &_atomic_dec_int_nv(($_p)));
	    }' unless defined(&atomic_dec_int_nv);
	    eval 'sub atomic_dec_long_nv {
	        my($_p) = @_;
    		eval q( &_atomic_dec_long_nv(($_p)));
	    }' unless defined(&atomic_dec_long_nv);
	    eval 'sub def_atomic_add_nv {
	        my($_f, $_t) = @_;
    		eval q( &static  &inline $_t $_f( &volatile $_t * &p, $_t  &v) { $_t  &ret,  &modified;  &__asm  &volatile ( \\"1:	ldrex %0, [%2]		\\\\n\\\\t\\" \\"	add %0, %0, %3		\\\\n\\\\t\\" \\"	strex %1, %0, [%2]	\\\\n\\\\t\\" \\"	cmp %1, #0		\\\\n\\\\t\\" \\"	bne 1b			\\\\n\\\\t\\" : \\"=&r\\" ( &ret), \\"=&r\\" ( &modified) : \\"r\\" ( &p), \\"r\\" ( &v) : \\"memory\\", \\"cc\\" );  &return ( &ret); });
	    }' unless defined(&def_atomic_add_nv);
	    undef(&def_atomic_add_nv) if defined(&def_atomic_add_nv);
	    eval 'sub atomic_add_int_nv {
	        my($_p, $_v) = @_;
    		eval q( &_atomic_add_int_nv(($_p), ($_v)));
	    }' unless defined(&atomic_add_int_nv);
	    eval 'sub atomic_add_long_nv {
	        my($_p, $_v) = @_;
    		eval q( &_atomic_add_long_nv(($_p), ($_v)));
	    }' unless defined(&atomic_add_long_nv);
	    eval 'sub def_atomic_sub_nv {
	        my($_f, $_t) = @_;
    		eval q( &static  &inline $_t $_f( &volatile $_t * &p, $_t  &v) { $_t  &ret,  &modified;  &__asm  &volatile ( \\"1:	ldrex %0, [%2]		\\\\n\\\\t\\" \\"	sub %0, %0, %3		\\\\n\\\\t\\" \\"	strex %1, %0, [%2]	\\\\n\\\\t\\" \\"	cmp %1, #0		\\\\n\\\\t\\" \\"	bne 1b			\\\\n\\\\t\\" : \\"=&r\\" ( &ret), \\"=&r\\" ( &modified) : \\"r\\" ( &p), \\"r\\" ( &v) : \\"memory\\", \\"cc\\" );  &return ( &ret); });
	    }' unless defined(&def_atomic_sub_nv);
	    undef(&def_atomic_sub_nv) if defined(&def_atomic_sub_nv);
	    eval 'sub atomic_sub_int_nv {
	        my($_p, $_v) = @_;
    		eval q( &_atomic_sub_int_nv(($_p), ($_v)));
	    }' unless defined(&atomic_sub_int_nv);
	    eval 'sub atomic_sub_long_nv {
	        my($_p, $_v) = @_;
    		eval q( &_atomic_sub_long_nv(($_p), ($_v)));
	    }' unless defined(&atomic_sub_long_nv);
	}
	if(!defined(&CPU_ARMv7)) {
	    eval 'sub __membar () {
	        eval q( &do {  &__asm  &__volatile(\\"\\" ::: \\"memory\\"); }  &while (0));
	    }' unless defined(&__membar);
	    eval 'sub membar_enter () {
	        eval q( &__membar());
	    }' unless defined(&membar_enter);
	    eval 'sub membar_exit () {
	        eval q( &__membar());
	    }' unless defined(&membar_exit);
	    eval 'sub membar_producer () {
	        eval q( &__membar());
	    }' unless defined(&membar_producer);
	    eval 'sub membar_consumer () {
	        eval q( &__membar());
	    }' unless defined(&membar_consumer);
	    eval 'sub membar_sync () {
	        eval q( &__membar());
	    }' unless defined(&membar_sync);
	} else {
	    eval 'sub __membar {
	        my($_f) = @_;
    		eval q( &do {  &__asm  &__volatile($_f ::: \\"memory\\"); }  &while (0));
	    }' unless defined(&__membar);
	    eval 'sub membar_enter () {
	        eval q( &__membar(\\"dmb sy\\"));
	    }' unless defined(&membar_enter);
	    eval 'sub membar_exit () {
	        eval q( &__membar(\\"dmb sy\\"));
	    }' unless defined(&membar_exit);
	    eval 'sub membar_producer () {
	        eval q( &__membar(\\"dmb st\\"));
	    }' unless defined(&membar_producer);
	    eval 'sub membar_consumer () {
	        eval q( &__membar(\\"dmb sy\\"));
	    }' unless defined(&membar_consumer);
	    eval 'sub membar_sync () {
	        eval q( &__membar(\\"dmb sy\\"));
	    }' unless defined(&membar_sync);
	    eval 'sub virtio_membar_producer () {
	        eval q( &__membar(\\"dmb st\\"));
	    }' unless defined(&virtio_membar_producer);
	    eval 'sub virtio_membar_consumer () {
	        eval q( &__membar(\\"dmb sy\\"));
	    }' unless defined(&virtio_membar_consumer);
	    eval 'sub virtio_membar_sync () {
	        eval q( &__membar(\\"dmb sy\\"));
	    }' unless defined(&virtio_membar_sync);
	}
    }
}
1;
