require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MACHINE_I8259_H_)) {
    eval 'sub _MACHINE_I8259_H_ () {1;}' unless defined(&_MACHINE_I8259_H_);
    require 'dev/isa/isareg.ph';
    unless(defined(&_LOCORE)) {
	eval 'sub SET_ICUS () {
	    eval q(( &outb( &IO_ICU1 + 1,  &imen),  &outb( &IO_ICU2 + 1,  &imen >> 8)));
	}' unless defined(&SET_ICUS);
    }
    eval 'sub IRQ_SLAVE () {2;}' unless defined(&IRQ_SLAVE);
    eval 'sub ICU_OFFSET () {32;}' unless defined(&ICU_OFFSET);
    eval 'sub ICU_LEN () {16;}' unless defined(&ICU_LEN);
    eval 'sub ICU_HARDWARE_MASK () {1;}' unless defined(&ICU_HARDWARE_MASK);
    eval 'sub IRQ_BIT {
        my($num) = @_;
	    eval q((1<< (($num) % 8)));
    }' unless defined(&IRQ_BIT);
    eval 'sub IRQ_BYTE {
        my($num) = @_;
	    eval q((($num) >> 3));
    }' unless defined(&IRQ_BYTE);
    eval 'sub i8259_late_ack {
        my($num) = @_;
	    eval q();
    }' unless defined(&i8259_late_ack);
    if(defined(&ICU_SPECIAL_MASK_MODE)) {
	eval 'sub i8259_asm_ack1 {
	    my($num) = @_;
    	    eval q();
	}' unless defined(&i8259_asm_ack1);
	eval 'sub i8259_asm_ack2 {
	    my($num) = @_;
    	    eval q( &movb $(0x60| &IRQ_SLAVE),% &al ;  &outb % &al,$ &IO_ICU1);
	}' unless defined(&i8259_asm_ack2);
	eval 'sub i8259_asm_mask {
	    my($num) = @_;
    	    eval q();
	}' unless defined(&i8259_asm_mask);
	eval 'sub i8259_asm_unmask {
	    my($num) = @_;
    	    eval q( &movb $(0x60|($num%8)),% &al ;  &outb % &al,$ &ICUADDR);
	}' unless defined(&i8259_asm_unmask);
    } else {
	unless(defined(&AUTO_EOI_1)) {
	    eval 'sub i8259_asm_ack1 {
	        my($num) = @_;
    		eval q( &movb $(0x60|($num%8)),% &al ;  &outb % &al,$ &IO_ICU1);
	    }' unless defined(&i8259_asm_ack1);
	} else {
	    eval 'sub i8259_asm_ack1 {
	        my($num) = @_;
    		eval q();
	    }' unless defined(&i8259_asm_ack1);
	}
	unless(defined(&AUTO_EOI_2)) {
	    eval 'sub i8259_asm_ack2 {
	        my($num) = @_;
    		eval q( &movb $(0x60|($num%8)),% &al ;  &outb % &al,$ &IO_ICU2 ;  &movb $(0x60| &IRQ_SLAVE),% &al ;  &outb % &al,$ &IO_ICU1);
	    }' unless defined(&i8259_asm_ack2);
	} else {
	    eval 'sub i8259_asm_ack2 {
	        my($num) = @_;
    		eval q();
	    }' unless defined(&i8259_asm_ack2);
	}
	if(defined(&ICU_HARDWARE_MASK)) {
	    eval 'sub i8259_asm_mask {
	        my($num) = @_;
    		eval q( &movb  &CVAROFF( &imen,  &IRQ_BYTE($num)),% &al ;  &orb $ &IRQ_BIT($num),% &al ;  &movb % &al, &CVAROFF( &imen,  &IRQ_BYTE($num)) ;  &pushl % &eax ;  &inb $0x84,% &al ;  &popl % &eax ;  &outb % &al,$( &ICUADDR+1));
	    }' unless defined(&i8259_asm_mask);
	    eval 'sub i8259_asm_unmask {
	        my($num) = @_;
    		eval q( &cli ;  &movb  &CVAROFF( &imen,  &IRQ_BYTE($num)),% &al ;  &andb $~ &IRQ_BIT($num),% &al ;  &movb % &al, &CVAROFF( &imen,  &IRQ_BYTE($num)) ;  &pushl % &eax ;  &inb $0x84,% &al ;  &popl % &eax ;  &outb % &al,$( &ICUADDR+1) ;  &sti);
	    }' unless defined(&i8259_asm_unmask);
	} else {
	    eval 'sub i8259_asm_mask {
	        my($num) = @_;
    		eval q();
	    }' unless defined(&i8259_asm_mask);
	    eval 'sub i8259_asm_unmask {
	        my($num) = @_;
    		eval q();
	    }' unless defined(&i8259_asm_unmask);
	}
    }
}
1;
