require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MACHINE_MUTEX_H_)) {
    eval 'sub _MACHINE_MUTEX_H_ () {1;}' unless defined(&_MACHINE_MUTEX_H_);
    if(defined(&MULTIPROCESSOR)) {
	eval 'sub __MUTEX_IPL {
	    my($ipl) = @_;
    	    eval q(((($ipl) >  &IPL_NONE  && ($ipl) <  &IPL_TTY) ?  &IPL_TTY : ($ipl)));
	}' unless defined(&__MUTEX_IPL);
    } else {
	eval 'sub __MUTEX_IPL {
	    my($ipl) = @_;
    	    eval q(($ipl));
	}' unless defined(&__MUTEX_IPL);
    }
    eval 'sub MUTEX_INITIALIZER {
        my($ipl) = @_;
	    eval q({ 0,  &__MUTEX_IPL(($ipl)), 0,  &NULL });
    }' unless defined(&MUTEX_INITIALIZER);
    eval 'sub mtx_init {
        my($mtx, $ipl) = @_;
	    eval q( &__mtx_init(($mtx),  &__MUTEX_IPL(($ipl))));
    }' unless defined(&mtx_init);
    eval 'sub MUTEX_ASSERT_LOCKED {
        my($mtx) = @_;
	    eval q( &do {  &if (($mtx)-> &mtx_owner !=  &curcpu())  &panic(\\"mutex %p not held in %s\\", ($mtx),  &__func__); }  &while (0));
    }' unless defined(&MUTEX_ASSERT_LOCKED);
    eval 'sub MUTEX_ASSERT_UNLOCKED {
        my($mtx) = @_;
	    eval q( &do {  &if (($mtx)-> &mtx_owner ==  &curcpu())  &panic(\\"mutex %p held in %s\\", ($mtx),  &__func__); }  &while (0));
    }' unless defined(&MUTEX_ASSERT_UNLOCKED);
    eval 'sub MUTEX_OLDIPL {
        my($mtx) = @_;
	    eval q(($mtx)-> &mtx_oldipl);
    }' unless defined(&MUTEX_OLDIPL);
}
1;
