require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_POWERPC_DB_MACHDEP_H_)) {
    eval 'sub _POWERPC_DB_MACHDEP_H_ () {1;}' unless defined(&_POWERPC_DB_MACHDEP_H_);
    require 'sys/types.ph';
    require 'uvm/uvm_param.ph';
    require 'machine/trap.ph';
    eval 'sub PC_REGS {
        my($regs) = @_;
	    eval q((($regs)-> &srr0));
    }' unless defined(&PC_REGS);
    eval 'sub SET_PC_REGS {
        my($regs, $value) = @_;
	    eval q( &PC_REGS($regs) = ($value));
    }' unless defined(&SET_PC_REGS);
    eval 'sub BKPT_INST () {0x7c810808;}' unless defined(&BKPT_INST);
    eval 'sub BKPT_SIZE () {(4);}' unless defined(&BKPT_SIZE);
    eval 'sub BKPT_SET {
        my($inst) = @_;
	    eval q(( &BKPT_INST));
    }' unless defined(&BKPT_SET);
    eval 'sub FIXUP_PC_AFTER_BREAK {
        my($regs) = @_;
	    eval q((($regs)-> &srr0 -= 4));
    }' unless defined(&FIXUP_PC_AFTER_BREAK);
    eval 'sub SR_SINGLESTEP () {0x8000;}' unless defined(&SR_SINGLESTEP);
    eval 'sub db_clear_single_step {
        my($regs) = @_;
	    eval q((($regs)-> &srr1 &= ~ &SR_SINGLESTEP));
    }' unless defined(&db_clear_single_step);
    eval 'sub db_set_single_step {
        my($regs) = @_;
	    eval q((($regs)-> &srr1 |=  &SR_SINGLESTEP));
    }' unless defined(&db_set_single_step);
    eval 'sub T_BREAKPOINT () {0xffff;}' unless defined(&T_BREAKPOINT);
    eval 'sub IS_BREAKPOINT_TRAP {
        my($type, $code) = @_;
	    eval q((($type) ==  &T_BREAKPOINT));
    }' unless defined(&IS_BREAKPOINT_TRAP);
    if(defined(&T_WATCHPOINT)) {
	eval 'sub IS_WATCHPOINT_TRAP {
	    my($type, $code) = @_;
    	    eval q((($type) ==  &T_WATCHPOINT));
	}' unless defined(&IS_WATCHPOINT_TRAP);
    } else {
	eval 'sub IS_WATCHPOINT_TRAP {
	    my($type, $code) = @_;
    	    eval q(0);
	}' unless defined(&IS_WATCHPOINT_TRAP);
    }
    eval 'sub M_RTS () {0xfc0007fe;}' unless defined(&M_RTS);
    eval 'sub I_RTS () {0x4c000020;}' unless defined(&I_RTS);
    eval 'sub M_BC () {0xfc000000;}' unless defined(&M_BC);
    eval 'sub I_BC () {0x40000000;}' unless defined(&I_BC);
    eval 'sub M_B () {0xfc000000;}' unless defined(&M_B);
    eval 'sub I_B () {0x50000000;}' unless defined(&I_B);
    eval 'sub M_RFI () {0xfc0007fe;}' unless defined(&M_RFI);
    eval 'sub I_RFI () {0x4c000064;}' unless defined(&I_RFI);
    eval 'sub inst_trap_return {
        my($ins) = @_;
	    eval q(((($ins) &M_RFI) ==  &I_RFI));
    }' unless defined(&inst_trap_return);
    eval 'sub inst_return {
        my($ins) = @_;
	    eval q(((($ins) &M_RTS) ==  &I_RTS));
    }' unless defined(&inst_return);
    eval 'sub inst_call {
        my($ins) = @_;
	    eval q(((($ins) &M_BC ) ==  &I_BC || (($ins) &M_B ) ==  &I_B ));
    }' unless defined(&inst_call);
    if(defined(&_KERNEL)) {
	eval 'sub DDB_STATE_NOT_RUNNING () {0;}' unless defined(&DDB_STATE_NOT_RUNNING);
	eval 'sub DDB_STATE_RUNNING () {1;}' unless defined(&DDB_STATE_RUNNING);
	eval 'sub DDB_STATE_EXITING () {2;}' unless defined(&DDB_STATE_EXITING);
	eval 'sub DB_MACHINE_COMMANDS () {1;}' unless defined(&DB_MACHINE_COMMANDS);
    }
}
1;
